/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a summary of an alarm model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlarmModelSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AlarmModelSummary.Builder, AlarmModelSummary> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(AlarmModelSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> ALARM_MODEL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelDescription").getter(getter(AlarmModelSummary::alarmModelDescription))
            .setter(setter(Builder::alarmModelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelDescription").build())
            .build();

    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelName").getter(getter(AlarmModelSummary::alarmModelName))
            .setter(setter(Builder::alarmModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            ALARM_MODEL_DESCRIPTION_FIELD, ALARM_MODEL_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final String alarmModelDescription;

    private final String alarmModelName;

    private AlarmModelSummary(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.alarmModelDescription = builder.alarmModelDescription;
        this.alarmModelName = builder.alarmModelName;
    }

    /**
     * <p>
     * The time the alarm model was created, in the Unix epoch format.
     * </p>
     * 
     * @return The time the alarm model was created, in the Unix epoch format.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The description of the alarm model.
     * </p>
     * 
     * @return The description of the alarm model.
     */
    public final String alarmModelDescription() {
        return alarmModelDescription;
    }

    /**
     * <p>
     * The name of the alarm model.
     * </p>
     * 
     * @return The name of the alarm model.
     */
    public final String alarmModelName() {
        return alarmModelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmModelSummary)) {
            return false;
        }
        AlarmModelSummary other = (AlarmModelSummary) obj;
        return Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(alarmModelDescription(), other.alarmModelDescription())
                && Objects.equals(alarmModelName(), other.alarmModelName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlarmModelSummary").add("CreationTime", creationTime())
                .add("AlarmModelDescription", alarmModelDescription()).add("AlarmModelName", alarmModelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "alarmModelDescription":
            return Optional.ofNullable(clazz.cast(alarmModelDescription()));
        case "alarmModelName":
            return Optional.ofNullable(clazz.cast(alarmModelName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlarmModelSummary, T> g) {
        return obj -> g.apply((AlarmModelSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlarmModelSummary> {
        /**
         * <p>
         * The time the alarm model was created, in the Unix epoch format.
         * </p>
         * 
         * @param creationTime
         *        The time the alarm model was created, in the Unix epoch format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The description of the alarm model.
         * </p>
         * 
         * @param alarmModelDescription
         *        The description of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelDescription(String alarmModelDescription);

        /**
         * <p>
         * The name of the alarm model.
         * </p>
         * 
         * @param alarmModelName
         *        The name of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelName(String alarmModelName);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private String alarmModelDescription;

        private String alarmModelName;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmModelSummary model) {
            creationTime(model.creationTime);
            alarmModelDescription(model.alarmModelDescription);
            alarmModelName(model.alarmModelName);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getAlarmModelDescription() {
            return alarmModelDescription;
        }

        public final void setAlarmModelDescription(String alarmModelDescription) {
            this.alarmModelDescription = alarmModelDescription;
        }

        @Override
        @Transient
        public final Builder alarmModelDescription(String alarmModelDescription) {
            this.alarmModelDescription = alarmModelDescription;
            return this;
        }

        public final String getAlarmModelName() {
            return alarmModelName;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        @Override
        @Transient
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        @Override
        public AlarmModelSummary build() {
            return new AlarmModelSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
