/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the result of the analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisResult implements SdkPojo, Serializable, ToCopyableBuilder<AnalysisResult.Builder, AnalysisResult> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AnalysisResult::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("level")
            .getter(getter(AnalysisResult::levelAsString)).setter(setter(Builder::level))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(AnalysisResult::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<List<AnalysisResultLocation>> LOCATIONS_FIELD = SdkField
            .<List<AnalysisResultLocation>> builder(MarshallingType.LIST)
            .memberName("locations")
            .getter(getter(AnalysisResult::locations))
            .setter(setter(Builder::locations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalysisResultLocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalysisResultLocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, LEVEL_FIELD,
            MESSAGE_FIELD, LOCATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String level;

    private final String message;

    private final List<AnalysisResultLocation> locations;

    private AnalysisResult(BuilderImpl builder) {
        this.type = builder.type;
        this.level = builder.level;
        this.message = builder.message;
        this.locations = builder.locations;
    }

    /**
     * <p>
     * The type of the analysis result. Analyses fall into the following types based on the validators used to generate
     * the analysis result:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>supported-actions</code> - You must specify AWS IoT Events supported actions that work with other AWS
     * services in a supported AWS Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>service-limits</code> - Resources or API operations can't exceed service quotas (also known as limits).
     * Update your detector model or request a quota increase.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>structure</code> - The detector model must follow a structure that AWS IoT Events supports.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>expression-syntax</code> - Your expression must follow the required syntax.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>data-type</code> - Data types referenced in the detector model must be compatible.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>referenced-data</code> - You must define the data referenced in your detector model before you can use the
     * data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>referenced-resource</code> - Resources that the detector model uses must be available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html">Running detector
     * model analyses</a> in the <i>AWS IoT Events Developer Guide</i>.
     * </p>
     * 
     * @return The type of the analysis result. Analyses fall into the following types based on the validators used to
     *         generate the analysis result:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>supported-actions</code> - You must specify AWS IoT Events supported actions that work with other
     *         AWS services in a supported AWS Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>service-limits</code> - Resources or API operations can't exceed service quotas (also known as
     *         limits). Update your detector model or request a quota increase.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>structure</code> - The detector model must follow a structure that AWS IoT Events supports.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>expression-syntax</code> - Your expression must follow the required syntax.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>data-type</code> - Data types referenced in the detector model must be compatible.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>referenced-data</code> - You must define the data referenced in your detector model before you can
     *         use the data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>referenced-resource</code> - Resources that the detector model uses must be available.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html">Running
     *         detector model analyses</a> in the <i>AWS IoT Events Developer Guide</i>.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The severity level of the analysis result. Based on the severity level, analysis results fall into three general
     * categories:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INFO</code> - An information result tells you about a significant field in your detector model. This type
     * of result usually doesn't require immediate action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARNING</code> - A warning result draws special attention to fields that might cause issues for your
     * detector model. We recommend that you review warnings and take necessary actions before you use your detector
     * model in production environments. Otherwise, the detector model might not work as expected.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code> - An error result notifies you about a problem found in your detector model. You must fix all
     * errors before you can publish your detector model.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link AnalysisResultLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return The severity level of the analysis result. Based on the severity level, analysis results fall into three
     *         general categories:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INFO</code> - An information result tells you about a significant field in your detector model.
     *         This type of result usually doesn't require immediate action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARNING</code> - A warning result draws special attention to fields that might cause issues for
     *         your detector model. We recommend that you review warnings and take necessary actions before you use your
     *         detector model in production environments. Otherwise, the detector model might not work as expected.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code> - An error result notifies you about a problem found in your detector model. You must
     *         fix all errors before you can publish your detector model.
     *         </p>
     *         </li>
     * @see AnalysisResultLevel
     */
    public final AnalysisResultLevel level() {
        return AnalysisResultLevel.fromValue(level);
    }

    /**
     * <p>
     * The severity level of the analysis result. Based on the severity level, analysis results fall into three general
     * categories:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INFO</code> - An information result tells you about a significant field in your detector model. This type
     * of result usually doesn't require immediate action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARNING</code> - A warning result draws special attention to fields that might cause issues for your
     * detector model. We recommend that you review warnings and take necessary actions before you use your detector
     * model in production environments. Otherwise, the detector model might not work as expected.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code> - An error result notifies you about a problem found in your detector model. You must fix all
     * errors before you can publish your detector model.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link AnalysisResultLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return The severity level of the analysis result. Based on the severity level, analysis results fall into three
     *         general categories:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INFO</code> - An information result tells you about a significant field in your detector model.
     *         This type of result usually doesn't require immediate action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARNING</code> - A warning result draws special attention to fields that might cause issues for
     *         your detector model. We recommend that you review warnings and take necessary actions before you use your
     *         detector model in production environments. Otherwise, the detector model might not work as expected.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code> - An error result notifies you about a problem found in your detector model. You must
     *         fix all errors before you can publish your detector model.
     *         </p>
     *         </li>
     * @see AnalysisResultLevel
     */
    public final String levelAsString() {
        return level;
    }

    /**
     * <p>
     * Contains additional information about the analysis result.
     * </p>
     * 
     * @return Contains additional information about the analysis result.
     */
    public final String message() {
        return message;
    }

    /**
     * For responses, this returns true if the service returned a value for the Locations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLocations() {
        return locations != null && !(locations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains one or more locations that you can use to locate the fields in your detector model that the analysis
     * result references.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocations} method.
     * </p>
     * 
     * @return Contains one or more locations that you can use to locate the fields in your detector model that the
     *         analysis result references.
     */
    public final List<AnalysisResultLocation> locations() {
        return locations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocations() ? locations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisResult)) {
            return false;
        }
        AnalysisResult other = (AnalysisResult) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(levelAsString(), other.levelAsString())
                && Objects.equals(message(), other.message()) && hasLocations() == other.hasLocations()
                && Objects.equals(locations(), other.locations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisResult").add("Type", type()).add("Level", levelAsString()).add("Message", message())
                .add("Locations", hasLocations() ? locations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "level":
            return Optional.ofNullable(clazz.cast(levelAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "locations":
            return Optional.ofNullable(clazz.cast(locations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisResult, T> g) {
        return obj -> g.apply((AnalysisResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisResult> {
        /**
         * <p>
         * The type of the analysis result. Analyses fall into the following types based on the validators used to
         * generate the analysis result:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>supported-actions</code> - You must specify AWS IoT Events supported actions that work with other AWS
         * services in a supported AWS Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>service-limits</code> - Resources or API operations can't exceed service quotas (also known as limits).
         * Update your detector model or request a quota increase.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>structure</code> - The detector model must follow a structure that AWS IoT Events supports.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expression-syntax</code> - Your expression must follow the required syntax.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>data-type</code> - Data types referenced in the detector model must be compatible.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>referenced-data</code> - You must define the data referenced in your detector model before you can use
         * the data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>referenced-resource</code> - Resources that the detector model uses must be available.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html">Running
         * detector model analyses</a> in the <i>AWS IoT Events Developer Guide</i>.
         * </p>
         * 
         * @param type
         *        The type of the analysis result. Analyses fall into the following types based on the validators used
         *        to generate the analysis result:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>supported-actions</code> - You must specify AWS IoT Events supported actions that work with
         *        other AWS services in a supported AWS Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>service-limits</code> - Resources or API operations can't exceed service quotas (also known as
         *        limits). Update your detector model or request a quota increase.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>structure</code> - The detector model must follow a structure that AWS IoT Events supports.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expression-syntax</code> - Your expression must follow the required syntax.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>data-type</code> - Data types referenced in the detector model must be compatible.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>referenced-data</code> - You must define the data referenced in your detector model before you
         *        can use the data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>referenced-resource</code> - Resources that the detector model uses must be available.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html">Running
         *        detector model analyses</a> in the <i>AWS IoT Events Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The severity level of the analysis result. Based on the severity level, analysis results fall into three
         * general categories:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INFO</code> - An information result tells you about a significant field in your detector model. This
         * type of result usually doesn't require immediate action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARNING</code> - A warning result draws special attention to fields that might cause issues for your
         * detector model. We recommend that you review warnings and take necessary actions before you use your detector
         * model in production environments. Otherwise, the detector model might not work as expected.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code> - An error result notifies you about a problem found in your detector model. You must fix
         * all errors before you can publish your detector model.
         * </p>
         * </li>
         * </ul>
         * 
         * @param level
         *        The severity level of the analysis result. Based on the severity level, analysis results fall into
         *        three general categories:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INFO</code> - An information result tells you about a significant field in your detector model.
         *        This type of result usually doesn't require immediate action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARNING</code> - A warning result draws special attention to fields that might cause issues for
         *        your detector model. We recommend that you review warnings and take necessary actions before you use
         *        your detector model in production environments. Otherwise, the detector model might not work as
         *        expected.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code> - An error result notifies you about a problem found in your detector model. You
         *        must fix all errors before you can publish your detector model.
         *        </p>
         *        </li>
         * @see AnalysisResultLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisResultLevel
         */
        Builder level(String level);

        /**
         * <p>
         * The severity level of the analysis result. Based on the severity level, analysis results fall into three
         * general categories:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INFO</code> - An information result tells you about a significant field in your detector model. This
         * type of result usually doesn't require immediate action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARNING</code> - A warning result draws special attention to fields that might cause issues for your
         * detector model. We recommend that you review warnings and take necessary actions before you use your detector
         * model in production environments. Otherwise, the detector model might not work as expected.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code> - An error result notifies you about a problem found in your detector model. You must fix
         * all errors before you can publish your detector model.
         * </p>
         * </li>
         * </ul>
         * 
         * @param level
         *        The severity level of the analysis result. Based on the severity level, analysis results fall into
         *        three general categories:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INFO</code> - An information result tells you about a significant field in your detector model.
         *        This type of result usually doesn't require immediate action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARNING</code> - A warning result draws special attention to fields that might cause issues for
         *        your detector model. We recommend that you review warnings and take necessary actions before you use
         *        your detector model in production environments. Otherwise, the detector model might not work as
         *        expected.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code> - An error result notifies you about a problem found in your detector model. You
         *        must fix all errors before you can publish your detector model.
         *        </p>
         *        </li>
         * @see AnalysisResultLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisResultLevel
         */
        Builder level(AnalysisResultLevel level);

        /**
         * <p>
         * Contains additional information about the analysis result.
         * </p>
         * 
         * @param message
         *        Contains additional information about the analysis result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * Contains one or more locations that you can use to locate the fields in your detector model that the analysis
         * result references.
         * </p>
         * 
         * @param locations
         *        Contains one or more locations that you can use to locate the fields in your detector model that the
         *        analysis result references.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(Collection<AnalysisResultLocation> locations);

        /**
         * <p>
         * Contains one or more locations that you can use to locate the fields in your detector model that the analysis
         * result references.
         * </p>
         * 
         * @param locations
         *        Contains one or more locations that you can use to locate the fields in your detector model that the
         *        analysis result references.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(AnalysisResultLocation... locations);

        /**
         * <p>
         * Contains one or more locations that you can use to locate the fields in your detector model that the analysis
         * result references.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AnalysisResultLocation>.Builder} avoiding
         * the need to create one manually via {@link List<AnalysisResultLocation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AnalysisResultLocation>.Builder#build()} is called
         * immediately and its result is passed to {@link #locations(List<AnalysisResultLocation>)}.
         * 
         * @param locations
         *        a consumer that will call methods on {@link List<AnalysisResultLocation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #locations(List<AnalysisResultLocation>)
         */
        Builder locations(Consumer<AnalysisResultLocation.Builder>... locations);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String level;

        private String message;

        private List<AnalysisResultLocation> locations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisResult model) {
            type(model.type);
            level(model.level);
            message(model.message);
            locations(model.locations);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getLevel() {
            return level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        @Transient
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        @Transient
        public final Builder level(AnalysisResultLevel level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final List<AnalysisResultLocation.Builder> getLocations() {
            List<AnalysisResultLocation.Builder> result = AnalysisResultLocationsCopier.copyToBuilder(this.locations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocations(Collection<AnalysisResultLocation.BuilderImpl> locations) {
            this.locations = AnalysisResultLocationsCopier.copyFromBuilder(locations);
        }

        @Override
        @Transient
        public final Builder locations(Collection<AnalysisResultLocation> locations) {
            this.locations = AnalysisResultLocationsCopier.copy(locations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder locations(AnalysisResultLocation... locations) {
            locations(Arrays.asList(locations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder locations(Consumer<AnalysisResultLocation.Builder>... locations) {
            locations(Stream.of(locations).map(c -> AnalysisResultLocation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AnalysisResult build() {
            return new AnalysisResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
