/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains an asset property value. For more information, see <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html">Variant</a> in the <i>AWS IoT
 * SiteWise API Reference</i>.
 * </p>
 * <p>
 * You must use expressions for all parameters in <code>AssetPropertyVariant</code>. The expressions accept literals,
 * operators, functions, references, and substitution templates.
 * </p>
 * <p class="title">
 * <b>Examples</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * For literal values, the expressions must contain single quotes. For example, the value for the
 * <code>integerValue</code> parameter can be <code>'100'</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For references, you must specify either variables or parameters. For example, the value for the
 * <code>booleanValue</code> parameter can be <code>$variable.offline</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution
 * template can also contain a combination of literals, operators, functions, references, and substitution templates.
 * </p>
 * <p>
 * In the following example, the value for the <code>doubleValue</code> parameter uses a substitution template.
 * </p>
 * <p>
 * <code>'${$input.TemperatureInput.sensorData.temperature * 6 / 5 + 32}'</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the
 * <i>AWS IoT Events Developer Guide</i>.
 * </p>
 * <p>
 * You must specify one of the following value types, depending on the <code>dataType</code> of the specified asset
 * property. For more information, see <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetProperty.html">AssetProperty</a> in the
 * <i>AWS IoT SiteWise API Reference</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetPropertyVariant implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetPropertyVariant.Builder, AssetPropertyVariant> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stringValue").getter(getter(AssetPropertyVariant::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()).build();

    private static final SdkField<String> INTEGER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("integerValue").getter(getter(AssetPropertyVariant::integerValue)).setter(setter(Builder::integerValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerValue").build()).build();

    private static final SdkField<String> DOUBLE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("doubleValue").getter(getter(AssetPropertyVariant::doubleValue)).setter(setter(Builder::doubleValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()).build();

    private static final SdkField<String> BOOLEAN_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("booleanValue").getter(getter(AssetPropertyVariant::booleanValue)).setter(setter(Builder::booleanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD,
            INTEGER_VALUE_FIELD, DOUBLE_VALUE_FIELD, BOOLEAN_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stringValue;

    private final String integerValue;

    private final String doubleValue;

    private final String booleanValue;

    private AssetPropertyVariant(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.integerValue = builder.integerValue;
        this.doubleValue = builder.doubleValue;
        this.booleanValue = builder.booleanValue;
    }

    /**
     * <p>
     * The asset property value is a string. You must use an expression, and the evaluated result should be a string.
     * </p>
     * 
     * @return The asset property value is a string. You must use an expression, and the evaluated result should be a
     *         string.
     */
    public final String stringValue() {
        return stringValue;
    }

    /**
     * <p>
     * The asset property value is an integer. You must use an expression, and the evaluated result should be an
     * integer.
     * </p>
     * 
     * @return The asset property value is an integer. You must use an expression, and the evaluated result should be an
     *         integer.
     */
    public final String integerValue() {
        return integerValue;
    }

    /**
     * <p>
     * The asset property value is a double. You must use an expression, and the evaluated result should be a double.
     * </p>
     * 
     * @return The asset property value is a double. You must use an expression, and the evaluated result should be a
     *         double.
     */
    public final String doubleValue() {
        return doubleValue;
    }

    /**
     * <p>
     * The asset property value is a Boolean value that must be <code>'TRUE'</code> or <code>'FALSE'</code>. You must
     * use an expression, and the evaluated result should be a Boolean value.
     * </p>
     * 
     * @return The asset property value is a Boolean value that must be <code>'TRUE'</code> or <code>'FALSE'</code>. You
     *         must use an expression, and the evaluated result should be a Boolean value.
     */
    public final String booleanValue() {
        return booleanValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetPropertyVariant)) {
            return false;
        }
        AssetPropertyVariant other = (AssetPropertyVariant) obj;
        return Objects.equals(stringValue(), other.stringValue()) && Objects.equals(integerValue(), other.integerValue())
                && Objects.equals(doubleValue(), other.doubleValue()) && Objects.equals(booleanValue(), other.booleanValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetPropertyVariant").add("StringValue", stringValue()).add("IntegerValue", integerValue())
                .add("DoubleValue", doubleValue()).add("BooleanValue", booleanValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "integerValue":
            return Optional.ofNullable(clazz.cast(integerValue()));
        case "doubleValue":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "booleanValue":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetPropertyVariant, T> g) {
        return obj -> g.apply((AssetPropertyVariant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetPropertyVariant> {
        /**
         * <p>
         * The asset property value is a string. You must use an expression, and the evaluated result should be a
         * string.
         * </p>
         * 
         * @param stringValue
         *        The asset property value is a string. You must use an expression, and the evaluated result should be a
         *        string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * The asset property value is an integer. You must use an expression, and the evaluated result should be an
         * integer.
         * </p>
         * 
         * @param integerValue
         *        The asset property value is an integer. You must use an expression, and the evaluated result should be
         *        an integer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerValue(String integerValue);

        /**
         * <p>
         * The asset property value is a double. You must use an expression, and the evaluated result should be a
         * double.
         * </p>
         * 
         * @param doubleValue
         *        The asset property value is a double. You must use an expression, and the evaluated result should be a
         *        double.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(String doubleValue);

        /**
         * <p>
         * The asset property value is a Boolean value that must be <code>'TRUE'</code> or <code>'FALSE'</code>. You
         * must use an expression, and the evaluated result should be a Boolean value.
         * </p>
         * 
         * @param booleanValue
         *        The asset property value is a Boolean value that must be <code>'TRUE'</code> or <code>'FALSE'</code>.
         *        You must use an expression, and the evaluated result should be a Boolean value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(String booleanValue);
    }

    static final class BuilderImpl implements Builder {
        private String stringValue;

        private String integerValue;

        private String doubleValue;

        private String booleanValue;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetPropertyVariant model) {
            stringValue(model.stringValue);
            integerValue(model.integerValue);
            doubleValue(model.doubleValue);
            booleanValue(model.booleanValue);
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        @Override
        @Transient
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final String getIntegerValue() {
            return integerValue;
        }

        public final void setIntegerValue(String integerValue) {
            this.integerValue = integerValue;
        }

        @Override
        @Transient
        public final Builder integerValue(String integerValue) {
            this.integerValue = integerValue;
            return this;
        }

        public final String getDoubleValue() {
            return doubleValue;
        }

        public final void setDoubleValue(String doubleValue) {
            this.doubleValue = doubleValue;
        }

        @Override
        @Transient
        public final Builder doubleValue(String doubleValue) {
            this.doubleValue = doubleValue;
            return this;
        }

        public final String getBooleanValue() {
            return booleanValue;
        }

        public final void setBooleanValue(String booleanValue) {
            this.booleanValue = booleanValue;
        }

        @Override
        @Transient
        public final Builder booleanValue(String booleanValue) {
            this.booleanValue = booleanValue;
            return this;
        }

        @Override
        public AssetPropertyVariant build() {
            return new AssetPropertyVariant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
