/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDetectorModelResponse extends IotEventsResponse implements
        ToCopyableBuilder<CreateDetectorModelResponse.Builder, CreateDetectorModelResponse> {
    private static final SdkField<DetectorModelConfiguration> DETECTOR_MODEL_CONFIGURATION_FIELD = SdkField
            .<DetectorModelConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("detectorModelConfiguration")
            .getter(getter(CreateDetectorModelResponse::detectorModelConfiguration))
            .setter(setter(Builder::detectorModelConfiguration))
            .constructor(DetectorModelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DETECTOR_MODEL_CONFIGURATION_FIELD));

    private final DetectorModelConfiguration detectorModelConfiguration;

    private CreateDetectorModelResponse(BuilderImpl builder) {
        super(builder);
        this.detectorModelConfiguration = builder.detectorModelConfiguration;
    }

    /**
     * <p>
     * Information about how the detector model is configured.
     * </p>
     * 
     * @return Information about how the detector model is configured.
     */
    public final DetectorModelConfiguration detectorModelConfiguration() {
        return detectorModelConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDetectorModelResponse)) {
            return false;
        }
        CreateDetectorModelResponse other = (CreateDetectorModelResponse) obj;
        return Objects.equals(detectorModelConfiguration(), other.detectorModelConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDetectorModelResponse").add("DetectorModelConfiguration", detectorModelConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorModelConfiguration":
            return Optional.ofNullable(clazz.cast(detectorModelConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDetectorModelResponse, T> g) {
        return obj -> g.apply((CreateDetectorModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDetectorModelResponse> {
        /**
         * <p>
         * Information about how the detector model is configured.
         * </p>
         * 
         * @param detectorModelConfiguration
         *        Information about how the detector model is configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelConfiguration(DetectorModelConfiguration detectorModelConfiguration);

        /**
         * <p>
         * Information about how the detector model is configured.
         * </p>
         * This is a convenience that creates an instance of the {@link DetectorModelConfiguration.Builder} avoiding the
         * need to create one manually via {@link DetectorModelConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DetectorModelConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #detectorModelConfiguration(DetectorModelConfiguration)}.
         * 
         * @param detectorModelConfiguration
         *        a consumer that will call methods on {@link DetectorModelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectorModelConfiguration(DetectorModelConfiguration)
         */
        default Builder detectorModelConfiguration(Consumer<DetectorModelConfiguration.Builder> detectorModelConfiguration) {
            return detectorModelConfiguration(DetectorModelConfiguration.builder().applyMutation(detectorModelConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl extends IotEventsResponse.BuilderImpl implements Builder {
        private DetectorModelConfiguration detectorModelConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDetectorModelResponse model) {
            super(model);
            detectorModelConfiguration(model.detectorModelConfiguration);
        }

        public final DetectorModelConfiguration.Builder getDetectorModelConfiguration() {
            return detectorModelConfiguration != null ? detectorModelConfiguration.toBuilder() : null;
        }

        public final void setDetectorModelConfiguration(DetectorModelConfiguration.BuilderImpl detectorModelConfiguration) {
            this.detectorModelConfiguration = detectorModelConfiguration != null ? detectorModelConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder detectorModelConfiguration(DetectorModelConfiguration detectorModelConfiguration) {
            this.detectorModelConfiguration = detectorModelConfiguration;
            return this;
        }

        @Override
        public CreateDetectorModelResponse build() {
            return new CreateDetectorModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
