/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDetectorModelAnalysisResponse extends IotEventsResponse implements
        ToCopyableBuilder<DescribeDetectorModelAnalysisResponse.Builder, DescribeDetectorModelAnalysisResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeDetectorModelAnalysisResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD));

    private final String status;

    private DescribeDetectorModelAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
    }

    /**
     * <p>
     * The status of the analysis activity. The status can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RUNNING</code> - AWS IoT Events is analyzing your detector model. This process can take several minutes to
     * complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETE</code> - AWS IoT Events finished analyzing your detector model.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - AWS IoT Events couldn't analyze your detector model. Try again later.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the analysis activity. The status can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> - AWS IoT Events is analyzing your detector model. This process can take several
     *         minutes to complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETE</code> - AWS IoT Events finished analyzing your detector model.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - AWS IoT Events couldn't analyze your detector model. Try again later.
     *         </p>
     *         </li>
     * @see AnalysisStatus
     */
    public final AnalysisStatus status() {
        return AnalysisStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the analysis activity. The status can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RUNNING</code> - AWS IoT Events is analyzing your detector model. This process can take several minutes to
     * complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETE</code> - AWS IoT Events finished analyzing your detector model.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - AWS IoT Events couldn't analyze your detector model. Try again later.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the analysis activity. The status can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> - AWS IoT Events is analyzing your detector model. This process can take several
     *         minutes to complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETE</code> - AWS IoT Events finished analyzing your detector model.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - AWS IoT Events couldn't analyze your detector model. Try again later.
     *         </p>
     *         </li>
     * @see AnalysisStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDetectorModelAnalysisResponse)) {
            return false;
        }
        DescribeDetectorModelAnalysisResponse other = (DescribeDetectorModelAnalysisResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDetectorModelAnalysisResponse").add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDetectorModelAnalysisResponse, T> g) {
        return obj -> g.apply((DescribeDetectorModelAnalysisResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDetectorModelAnalysisResponse> {
        /**
         * <p>
         * The status of the analysis activity. The status can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RUNNING</code> - AWS IoT Events is analyzing your detector model. This process can take several minutes
         * to complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETE</code> - AWS IoT Events finished analyzing your detector model.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - AWS IoT Events couldn't analyze your detector model. Try again later.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the analysis activity. The status can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> - AWS IoT Events is analyzing your detector model. This process can take several
         *        minutes to complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETE</code> - AWS IoT Events finished analyzing your detector model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - AWS IoT Events couldn't analyze your detector model. Try again later.
         *        </p>
         *        </li>
         * @see AnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the analysis activity. The status can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RUNNING</code> - AWS IoT Events is analyzing your detector model. This process can take several minutes
         * to complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETE</code> - AWS IoT Events finished analyzing your detector model.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - AWS IoT Events couldn't analyze your detector model. Try again later.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the analysis activity. The status can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> - AWS IoT Events is analyzing your detector model. This process can take several
         *        minutes to complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETE</code> - AWS IoT Events finished analyzing your detector model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - AWS IoT Events couldn't analyze your detector model. Try again later.
         *        </p>
         *        </li>
         * @see AnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisStatus
         */
        Builder status(AnalysisStatus status);
    }

    static final class BuilderImpl extends IotEventsResponse.BuilderImpl implements Builder {
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDetectorModelAnalysisResponse model) {
            super(model);
            status(model.status);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(AnalysisStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DescribeDetectorModelAnalysisResponse build() {
            return new DescribeDetectorModelAnalysisResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
