/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm
 * model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InitializationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InitializationConfiguration.Builder, InitializationConfiguration> {
    private static final SdkField<Boolean> DISABLED_ON_INITIALIZATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("disabledOnInitialization").getter(getter(InitializationConfiguration::disabledOnInitialization))
            .setter(setter(Builder::disabledOnInitialization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disabledOnInitialization").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DISABLED_ON_INITIALIZATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean disabledOnInitialization;

    private InitializationConfiguration(BuilderImpl builder) {
        this.disabledOnInitialization = builder.disabledOnInitialization;
    }

    /**
     * <p>
     * The value must be <code>TRUE</code> or <code>FALSE</code>. If <code>FALSE</code>, all alarm instances created
     * based on the alarm model are activated. The default value is <code>TRUE</code>.
     * </p>
     * 
     * @return The value must be <code>TRUE</code> or <code>FALSE</code>. If <code>FALSE</code>, all alarm instances
     *         created based on the alarm model are activated. The default value is <code>TRUE</code>.
     */
    public final Boolean disabledOnInitialization() {
        return disabledOnInitialization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(disabledOnInitialization());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitializationConfiguration)) {
            return false;
        }
        InitializationConfiguration other = (InitializationConfiguration) obj;
        return Objects.equals(disabledOnInitialization(), other.disabledOnInitialization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InitializationConfiguration").add("DisabledOnInitialization", disabledOnInitialization())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "disabledOnInitialization":
            return Optional.ofNullable(clazz.cast(disabledOnInitialization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InitializationConfiguration, T> g) {
        return obj -> g.apply((InitializationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InitializationConfiguration> {
        /**
         * <p>
         * The value must be <code>TRUE</code> or <code>FALSE</code>. If <code>FALSE</code>, all alarm instances created
         * based on the alarm model are activated. The default value is <code>TRUE</code>.
         * </p>
         * 
         * @param disabledOnInitialization
         *        The value must be <code>TRUE</code> or <code>FALSE</code>. If <code>FALSE</code>, all alarm instances
         *        created based on the alarm model are activated. The default value is <code>TRUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledOnInitialization(Boolean disabledOnInitialization);
    }

    static final class BuilderImpl implements Builder {
        private Boolean disabledOnInitialization;

        private BuilderImpl() {
        }

        private BuilderImpl(InitializationConfiguration model) {
            disabledOnInitialization(model.disabledOnInitialization);
        }

        public final Boolean getDisabledOnInitialization() {
            return disabledOnInitialization;
        }

        public final void setDisabledOnInitialization(Boolean disabledOnInitialization) {
            this.disabledOnInitialization = disabledOnInitialization;
        }

        @Override
        @Transient
        public final Builder disabledOnInitialization(Boolean disabledOnInitialization) {
            this.disabledOnInitialization = disabledOnInitialization;
            return this;
        }

        @Override
        public InitializationConfiguration build() {
            return new InitializationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
