/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Input implements SdkPojo, Serializable, ToCopyableBuilder<Input.Builder, Input> {
    private static final SdkField<InputConfiguration> INPUT_CONFIGURATION_FIELD = SdkField
            .<InputConfiguration> builder(MarshallingType.SDK_POJO).memberName("inputConfiguration")
            .getter(getter(Input::inputConfiguration)).setter(setter(Builder::inputConfiguration))
            .constructor(InputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConfiguration").build())
            .build();

    private static final SdkField<InputDefinition> INPUT_DEFINITION_FIELD = SdkField
            .<InputDefinition> builder(MarshallingType.SDK_POJO).memberName("inputDefinition")
            .getter(getter(Input::inputDefinition)).setter(setter(Builder::inputDefinition))
            .constructor(InputDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_CONFIGURATION_FIELD,
            INPUT_DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final InputConfiguration inputConfiguration;

    private final InputDefinition inputDefinition;

    private Input(BuilderImpl builder) {
        this.inputConfiguration = builder.inputConfiguration;
        this.inputDefinition = builder.inputDefinition;
    }

    /**
     * <p>
     * Information about the configuration of an input.
     * </p>
     * 
     * @return Information about the configuration of an input.
     */
    public final InputConfiguration inputConfiguration() {
        return inputConfiguration;
    }

    /**
     * <p>
     * The definition of the input.
     * </p>
     * 
     * @return The definition of the input.
     */
    public final InputDefinition inputDefinition() {
        return inputDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(inputDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Input)) {
            return false;
        }
        Input other = (Input) obj;
        return Objects.equals(inputConfiguration(), other.inputConfiguration())
                && Objects.equals(inputDefinition(), other.inputDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Input").add("InputConfiguration", inputConfiguration())
                .add("InputDefinition", inputDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputConfiguration":
            return Optional.ofNullable(clazz.cast(inputConfiguration()));
        case "inputDefinition":
            return Optional.ofNullable(clazz.cast(inputDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Input, T> g) {
        return obj -> g.apply((Input) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Input> {
        /**
         * <p>
         * Information about the configuration of an input.
         * </p>
         * 
         * @param inputConfiguration
         *        Information about the configuration of an input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfiguration(InputConfiguration inputConfiguration);

        /**
         * <p>
         * Information about the configuration of an input.
         * </p>
         * This is a convenience that creates an instance of the {@link InputConfiguration.Builder} avoiding the need to
         * create one manually via {@link InputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #inputConfiguration(InputConfiguration)}.
         * 
         * @param inputConfiguration
         *        a consumer that will call methods on {@link InputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfiguration(InputConfiguration)
         */
        default Builder inputConfiguration(Consumer<InputConfiguration.Builder> inputConfiguration) {
            return inputConfiguration(InputConfiguration.builder().applyMutation(inputConfiguration).build());
        }

        /**
         * <p>
         * The definition of the input.
         * </p>
         * 
         * @param inputDefinition
         *        The definition of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDefinition(InputDefinition inputDefinition);

        /**
         * <p>
         * The definition of the input.
         * </p>
         * This is a convenience that creates an instance of the {@link InputDefinition.Builder} avoiding the need to
         * create one manually via {@link InputDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDefinition(InputDefinition)}.
         * 
         * @param inputDefinition
         *        a consumer that will call methods on {@link InputDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDefinition(InputDefinition)
         */
        default Builder inputDefinition(Consumer<InputDefinition.Builder> inputDefinition) {
            return inputDefinition(InputDefinition.builder().applyMutation(inputDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InputConfiguration inputConfiguration;

        private InputDefinition inputDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(Input model) {
            inputConfiguration(model.inputConfiguration);
            inputDefinition(model.inputDefinition);
        }

        public final InputConfiguration.Builder getInputConfiguration() {
            return inputConfiguration != null ? inputConfiguration.toBuilder() : null;
        }

        public final void setInputConfiguration(InputConfiguration.BuilderImpl inputConfiguration) {
            this.inputConfiguration = inputConfiguration != null ? inputConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder inputConfiguration(InputConfiguration inputConfiguration) {
            this.inputConfiguration = inputConfiguration;
            return this;
        }

        public final InputDefinition.Builder getInputDefinition() {
            return inputDefinition != null ? inputDefinition.toBuilder() : null;
        }

        public final void setInputDefinition(InputDefinition.BuilderImpl inputDefinition) {
            this.inputDefinition = inputDefinition != null ? inputDefinition.build() : null;
        }

        @Override
        @Transient
        public final Builder inputDefinition(InputDefinition inputDefinition) {
            this.inputDefinition = inputDefinition;
            return this;
        }

        @Override
        public Input build() {
            return new Input(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
