/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information required to reset the timer. The timer is reset to the previously evaluated result of the duration. The
 * duration expression isn't reevaluated when you reset the timer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResetTimerAction implements SdkPojo, Serializable,
        ToCopyableBuilder<ResetTimerAction.Builder, ResetTimerAction> {
    private static final SdkField<String> TIMER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timerName").getter(getter(ResetTimerAction::timerName)).setter(setter(Builder::timerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timerName;

    private ResetTimerAction(BuilderImpl builder) {
        this.timerName = builder.timerName;
    }

    /**
     * <p>
     * The name of the timer to reset.
     * </p>
     * 
     * @return The name of the timer to reset.
     */
    public final String timerName() {
        return timerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timerName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetTimerAction)) {
            return false;
        }
        ResetTimerAction other = (ResetTimerAction) obj;
        return Objects.equals(timerName(), other.timerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResetTimerAction").add("TimerName", timerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timerName":
            return Optional.ofNullable(clazz.cast(timerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResetTimerAction, T> g) {
        return obj -> g.apply((ResetTimerAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResetTimerAction> {
        /**
         * <p>
         * The name of the timer to reset.
         * </p>
         * 
         * @param timerName
         *        The name of the timer to reset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timerName(String timerName);
    }

    static final class BuilderImpl implements Builder {
        private String timerName;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetTimerAction model) {
            timerName(model.timerName);
        }

        public final String getTimerName() {
            return timerName;
        }

        public final void setTimerName(String timerName) {
            this.timerName = timerName;
        }

        @Override
        @Transient
        public final Builder timerName(String timerName) {
            this.timerName = timerName;
            return this;
        }

        @Override
        public ResetTimerAction build() {
            return new ResetTimerAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
