/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule that compares an input property value to a threshold value with a comparison operator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimpleRule implements SdkPojo, Serializable, ToCopyableBuilder<SimpleRule.Builder, SimpleRule> {
    private static final SdkField<String> INPUT_PROPERTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputProperty").getter(getter(SimpleRule::inputProperty)).setter(setter(Builder::inputProperty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputProperty").build()).build();

    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("comparisonOperator").getter(getter(SimpleRule::comparisonOperatorAsString))
            .setter(setter(Builder::comparisonOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparisonOperator").build())
            .build();

    private static final SdkField<String> THRESHOLD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("threshold").getter(getter(SimpleRule::threshold)).setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_PROPERTY_FIELD,
            COMPARISON_OPERATOR_FIELD, THRESHOLD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputProperty;

    private final String comparisonOperator;

    private final String threshold;

    private SimpleRule(BuilderImpl builder) {
        this.inputProperty = builder.inputProperty;
        this.comparisonOperator = builder.comparisonOperator;
        this.threshold = builder.threshold;
    }

    /**
     * <p>
     * The value on the left side of the comparison operator. You can specify an AWS IoT Events input attribute as an
     * input property.
     * </p>
     * 
     * @return The value on the left side of the comparison operator. You can specify an AWS IoT Events input attribute
     *         as an input property.
     */
    public final String inputProperty() {
        return inputProperty;
    }

    /**
     * <p>
     * The comparison operator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The comparison operator.
     * @see ComparisonOperator
     */
    public final ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(comparisonOperator);
    }

    /**
     * <p>
     * The comparison operator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The comparison operator.
     * @see ComparisonOperator
     */
    public final String comparisonOperatorAsString() {
        return comparisonOperator;
    }

    /**
     * <p>
     * The value on the right side of the comparison operator. You can enter a number or specify an AWS IoT Events input
     * attribute.
     * </p>
     * 
     * @return The value on the right side of the comparison operator. You can enter a number or specify an AWS IoT
     *         Events input attribute.
     */
    public final String threshold() {
        return threshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputProperty());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleRule)) {
            return false;
        }
        SimpleRule other = (SimpleRule) obj;
        return Objects.equals(inputProperty(), other.inputProperty())
                && Objects.equals(comparisonOperatorAsString(), other.comparisonOperatorAsString())
                && Objects.equals(threshold(), other.threshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SimpleRule").add("InputProperty", inputProperty())
                .add("ComparisonOperator", comparisonOperatorAsString()).add("Threshold", threshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputProperty":
            return Optional.ofNullable(clazz.cast(inputProperty()));
        case "comparisonOperator":
            return Optional.ofNullable(clazz.cast(comparisonOperatorAsString()));
        case "threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimpleRule, T> g) {
        return obj -> g.apply((SimpleRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimpleRule> {
        /**
         * <p>
         * The value on the left side of the comparison operator. You can specify an AWS IoT Events input attribute as
         * an input property.
         * </p>
         * 
         * @param inputProperty
         *        The value on the left side of the comparison operator. You can specify an AWS IoT Events input
         *        attribute as an input property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputProperty(String inputProperty);

        /**
         * <p>
         * The comparison operator.
         * </p>
         * 
         * @param comparisonOperator
         *        The comparison operator.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * <p>
         * The comparison operator.
         * </p>
         * 
         * @param comparisonOperator
         *        The comparison operator.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(ComparisonOperator comparisonOperator);

        /**
         * <p>
         * The value on the right side of the comparison operator. You can enter a number or specify an AWS IoT Events
         * input attribute.
         * </p>
         * 
         * @param threshold
         *        The value on the right side of the comparison operator. You can enter a number or specify an AWS IoT
         *        Events input attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(String threshold);
    }

    static final class BuilderImpl implements Builder {
        private String inputProperty;

        private String comparisonOperator;

        private String threshold;

        private BuilderImpl() {
        }

        private BuilderImpl(SimpleRule model) {
            inputProperty(model.inputProperty);
            comparisonOperator(model.comparisonOperator);
            threshold(model.threshold);
        }

        public final String getInputProperty() {
            return inputProperty;
        }

        public final void setInputProperty(String inputProperty) {
            this.inputProperty = inputProperty;
        }

        @Override
        @Transient
        public final Builder inputProperty(String inputProperty) {
            this.inputProperty = inputProperty;
            return this;
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        @Transient
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        @Transient
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final String getThreshold() {
            return threshold;
        }

        public final void setThreshold(String threshold) {
            this.threshold = threshold;
        }

        @Override
        @Transient
        public final Builder threshold(String threshold) {
            this.threshold = threshold;
            return this;
        }

        @Override
        public SimpleRule build() {
            return new SimpleRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
