/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.DetectorModelVersionStatus;
import software.amazon.awssdk.services.iotevents.model.EvaluationMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectorModelVersionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectorModelVersionSummary> {
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorModelName").getter(DetectorModelVersionSummary.getter(DetectorModelVersionSummary::detectorModelName)).setter(DetectorModelVersionSummary.setter(Builder::detectorModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelName").build()}).build();
    private static final SdkField<String> DETECTOR_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorModelVersion").getter(DetectorModelVersionSummary.getter(DetectorModelVersionSummary::detectorModelVersion)).setter(DetectorModelVersionSummary.setter(Builder::detectorModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelVersion").build()}).build();
    private static final SdkField<String> DETECTOR_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorModelArn").getter(DetectorModelVersionSummary.getter(DetectorModelVersionSummary::detectorModelArn)).setter(DetectorModelVersionSummary.setter(Builder::detectorModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DetectorModelVersionSummary.getter(DetectorModelVersionSummary::roleArn)).setter(DetectorModelVersionSummary.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(DetectorModelVersionSummary.getter(DetectorModelVersionSummary::creationTime)).setter(DetectorModelVersionSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(DetectorModelVersionSummary.getter(DetectorModelVersionSummary::lastUpdateTime)).setter(DetectorModelVersionSummary.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DetectorModelVersionSummary.getter(DetectorModelVersionSummary::statusAsString)).setter(DetectorModelVersionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> EVALUATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationMethod").getter(DetectorModelVersionSummary.getter(DetectorModelVersionSummary::evaluationMethodAsString)).setter(DetectorModelVersionSummary.setter(Builder::evaluationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_NAME_FIELD, DETECTOR_MODEL_VERSION_FIELD, DETECTOR_MODEL_ARN_FIELD, ROLE_ARN_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, STATUS_FIELD, EVALUATION_METHOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String detectorModelName;
    private final String detectorModelVersion;
    private final String detectorModelArn;
    private final String roleArn;
    private final Instant creationTime;
    private final Instant lastUpdateTime;
    private final String status;
    private final String evaluationMethod;

    private DetectorModelVersionSummary(BuilderImpl builder) {
        this.detectorModelName = builder.detectorModelName;
        this.detectorModelVersion = builder.detectorModelVersion;
        this.detectorModelArn = builder.detectorModelArn;
        this.roleArn = builder.roleArn;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.status = builder.status;
        this.evaluationMethod = builder.evaluationMethod;
    }

    public final String detectorModelName() {
        return this.detectorModelName;
    }

    public final String detectorModelVersion() {
        return this.detectorModelVersion;
    }

    public final String detectorModelArn() {
        return this.detectorModelArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final DetectorModelVersionStatus status() {
        return DetectorModelVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final EvaluationMethod evaluationMethod() {
        return EvaluationMethod.fromValue(this.evaluationMethod);
    }

    public final String evaluationMethodAsString() {
        return this.evaluationMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationMethodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorModelVersionSummary)) {
            return false;
        }
        DetectorModelVersionSummary other = (DetectorModelVersionSummary)obj;
        return Objects.equals(this.detectorModelName(), other.detectorModelName()) && Objects.equals(this.detectorModelVersion(), other.detectorModelVersion()) && Objects.equals(this.detectorModelArn(), other.detectorModelArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.evaluationMethodAsString(), other.evaluationMethodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DetectorModelVersionSummary").add("DetectorModelName", (Object)this.detectorModelName()).add("DetectorModelVersion", (Object)this.detectorModelVersion()).add("DetectorModelArn", (Object)this.detectorModelArn()).add("RoleArn", (Object)this.roleArn()).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("Status", (Object)this.statusAsString()).add("EvaluationMethod", (Object)this.evaluationMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorModelName": {
                return Optional.ofNullable(clazz.cast(this.detectorModelName()));
            }
            case "detectorModelVersion": {
                return Optional.ofNullable(clazz.cast(this.detectorModelVersion()));
            }
            case "detectorModelArn": {
                return Optional.ofNullable(clazz.cast(this.detectorModelArn()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "evaluationMethod": {
                return Optional.ofNullable(clazz.cast(this.evaluationMethodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectorModelVersionSummary, T> g) {
        return obj -> g.apply((DetectorModelVersionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String detectorModelName;
        private String detectorModelVersion;
        private String detectorModelArn;
        private String roleArn;
        private Instant creationTime;
        private Instant lastUpdateTime;
        private String status;
        private String evaluationMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorModelVersionSummary model) {
            this.detectorModelName(model.detectorModelName);
            this.detectorModelVersion(model.detectorModelVersion);
            this.detectorModelArn(model.detectorModelArn);
            this.roleArn(model.roleArn);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.status(model.status);
            this.evaluationMethod(model.evaluationMethod);
        }

        public final String getDetectorModelName() {
            return this.detectorModelName;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        @Override
        @Transient
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final String getDetectorModelVersion() {
            return this.detectorModelVersion;
        }

        public final void setDetectorModelVersion(String detectorModelVersion) {
            this.detectorModelVersion = detectorModelVersion;
        }

        @Override
        @Transient
        public final Builder detectorModelVersion(String detectorModelVersion) {
            this.detectorModelVersion = detectorModelVersion;
            return this;
        }

        public final String getDetectorModelArn() {
            return this.detectorModelArn;
        }

        public final void setDetectorModelArn(String detectorModelArn) {
            this.detectorModelArn = detectorModelArn;
        }

        @Override
        @Transient
        public final Builder detectorModelArn(String detectorModelArn) {
            this.detectorModelArn = detectorModelArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(DetectorModelVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEvaluationMethod() {
            return this.evaluationMethod;
        }

        public final void setEvaluationMethod(String evaluationMethod) {
            this.evaluationMethod = evaluationMethod;
        }

        @Override
        @Transient
        public final Builder evaluationMethod(String evaluationMethod) {
            this.evaluationMethod = evaluationMethod;
            return this;
        }

        @Override
        @Transient
        public final Builder evaluationMethod(EvaluationMethod evaluationMethod) {
            this.evaluationMethod(evaluationMethod == null ? null : evaluationMethod.toString());
            return this;
        }

        public DetectorModelVersionSummary build() {
            return new DetectorModelVersionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectorModelVersionSummary> {
        public Builder detectorModelName(String var1);

        public Builder detectorModelVersion(String var1);

        public Builder detectorModelArn(String var1);

        public Builder roleArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder status(String var1);

        public Builder status(DetectorModelVersionStatus var1);

        public Builder evaluationMethod(String var1);

        public Builder evaluationMethod(EvaluationMethod var1);
    }
}

