/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.InputDefinition;
import software.amazon.awssdk.services.iotevents.model.IotEventsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInputRequest
extends IotEventsRequest
implements ToCopyableBuilder<Builder, UpdateInputRequest> {
    private static final SdkField<String> INPUT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputName").getter(UpdateInputRequest.getter(UpdateInputRequest::inputName)).setter(UpdateInputRequest.setter(Builder::inputName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("inputName").build()}).build();
    private static final SdkField<String> INPUT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputDescription").getter(UpdateInputRequest.getter(UpdateInputRequest::inputDescription)).setter(UpdateInputRequest.setter(Builder::inputDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDescription").build()}).build();
    private static final SdkField<InputDefinition> INPUT_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputDefinition").getter(UpdateInputRequest.getter(UpdateInputRequest::inputDefinition)).setter(UpdateInputRequest.setter(Builder::inputDefinition)).constructor(InputDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_NAME_FIELD, INPUT_DESCRIPTION_FIELD, INPUT_DEFINITION_FIELD));
    private final String inputName;
    private final String inputDescription;
    private final InputDefinition inputDefinition;

    private UpdateInputRequest(BuilderImpl builder) {
        super(builder);
        this.inputName = builder.inputName;
        this.inputDescription = builder.inputDescription;
        this.inputDefinition = builder.inputDefinition;
    }

    public final String inputName() {
        return this.inputName;
    }

    public final String inputDescription() {
        return this.inputDescription;
    }

    public final InputDefinition inputDefinition() {
        return this.inputDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inputName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDefinition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInputRequest)) {
            return false;
        }
        UpdateInputRequest other = (UpdateInputRequest)((Object)obj);
        return Objects.equals(this.inputName(), other.inputName()) && Objects.equals(this.inputDescription(), other.inputDescription()) && Objects.equals(this.inputDefinition(), other.inputDefinition());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateInputRequest").add("InputName", (Object)this.inputName()).add("InputDescription", (Object)this.inputDescription()).add("InputDefinition", (Object)this.inputDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputName": {
                return Optional.ofNullable(clazz.cast(this.inputName()));
            }
            case "inputDescription": {
                return Optional.ofNullable(clazz.cast(this.inputDescription()));
            }
            case "inputDefinition": {
                return Optional.ofNullable(clazz.cast(this.inputDefinition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInputRequest, T> g) {
        return obj -> g.apply((UpdateInputRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsRequest.BuilderImpl
    implements Builder {
        private String inputName;
        private String inputDescription;
        private InputDefinition inputDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInputRequest model) {
            super(model);
            this.inputName(model.inputName);
            this.inputDescription(model.inputDescription);
            this.inputDefinition(model.inputDefinition);
        }

        public final String getInputName() {
            return this.inputName;
        }

        public final void setInputName(String inputName) {
            this.inputName = inputName;
        }

        @Override
        @Transient
        public final Builder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public final String getInputDescription() {
            return this.inputDescription;
        }

        public final void setInputDescription(String inputDescription) {
            this.inputDescription = inputDescription;
        }

        @Override
        @Transient
        public final Builder inputDescription(String inputDescription) {
            this.inputDescription = inputDescription;
            return this;
        }

        public final InputDefinition.Builder getInputDefinition() {
            return this.inputDefinition != null ? this.inputDefinition.toBuilder() : null;
        }

        public final void setInputDefinition(InputDefinition.BuilderImpl inputDefinition) {
            this.inputDefinition = inputDefinition != null ? inputDefinition.build() : null;
        }

        @Override
        @Transient
        public final Builder inputDefinition(InputDefinition inputDefinition) {
            this.inputDefinition = inputDefinition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInputRequest build() {
            return new UpdateInputRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotEventsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInputRequest> {
        public Builder inputName(String var1);

        public Builder inputDescription(String var1);

        public Builder inputDefinition(InputDefinition var1);

        default public Builder inputDefinition(Consumer<InputDefinition.Builder> inputDefinition) {
            return this.inputDefinition((InputDefinition)((InputDefinition.Builder)InputDefinition.builder().applyMutation(inputDefinition)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

