/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmailContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmailContent> {
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subject").getter(EmailContent.getter(EmailContent::subject)).setter(EmailContent.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()}).build();
    private static final SdkField<String> ADDITIONAL_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("additionalMessage").getter(EmailContent.getter(EmailContent::additionalMessage)).setter(EmailContent.setter(Builder::additionalMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD, ADDITIONAL_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EmailContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String subject;
    private final String additionalMessage;

    private EmailContent(BuilderImpl builder) {
        this.subject = builder.subject;
        this.additionalMessage = builder.additionalMessage;
    }

    public final String subject() {
        return this.subject;
    }

    public final String additionalMessage() {
        return this.additionalMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailContent)) {
            return false;
        }
        EmailContent other = (EmailContent)obj;
        return Objects.equals(this.subject(), other.subject()) && Objects.equals(this.additionalMessage(), other.additionalMessage());
    }

    public final String toString() {
        return ToString.builder((String)"EmailContent").add("Subject", (Object)this.subject()).add("AdditionalMessage", (Object)this.additionalMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "additionalMessage": {
                return Optional.ofNullable(clazz.cast(this.additionalMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("subject", SUBJECT_FIELD);
        map.put("additionalMessage", ADDITIONAL_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailContent, T> g) {
        return obj -> g.apply((EmailContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subject;
        private String additionalMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailContent model) {
            this.subject(model.subject);
            this.additionalMessage(model.additionalMessage);
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getAdditionalMessage() {
            return this.additionalMessage;
        }

        public final void setAdditionalMessage(String additionalMessage) {
            this.additionalMessage = additionalMessage;
        }

        @Override
        public final Builder additionalMessage(String additionalMessage) {
            this.additionalMessage = additionalMessage;
            return this;
        }

        public EmailContent build() {
            return new EmailContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmailContent> {
        public Builder subject(String var1);

        public Builder additionalMessage(String var1);
    }
}

