/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AlarmModelVersionStatus {
    ACTIVE("ACTIVE"),
    ACTIVATING("ACTIVATING"),
    INACTIVE("INACTIVE"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AlarmModelVersionStatus> VALUE_MAP;
    private final String value;

    private AlarmModelVersionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AlarmModelVersionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AlarmModelVersionStatus> knownValues() {
        EnumSet<AlarmModelVersionStatus> knownValues = EnumSet.allOf(AlarmModelVersionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AlarmModelVersionStatus.class, AlarmModelVersionStatus::toString);
    }
}

