/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotmanagedintegrations.model.AuthMaterialType;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilityReport;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MetaDataCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.Role;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateManagedThingRequest
extends IotManagedIntegrationsRequest
implements ToCopyableBuilder<Builder, CreateManagedThingRequest> {
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(CreateManagedThingRequest.getter(CreateManagedThingRequest::roleAsString)).setter(CreateManagedThingRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(CreateManagedThingRequest.getter(CreateManagedThingRequest::owner)).setter(CreateManagedThingRequest.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> CREDENTIAL_LOCKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CredentialLockerId").getter(CreateManagedThingRequest.getter(CreateManagedThingRequest::credentialLockerId)).setter(CreateManagedThingRequest.setter(Builder::credentialLockerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialLockerId").build()}).build();
    private static final SdkField<String> AUTHENTICATION_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationMaterial").getter(CreateManagedThingRequest.getter(CreateManagedThingRequest::authenticationMaterial)).setter(CreateManagedThingRequest.setter(Builder::authenticationMaterial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMaterial").build()}).build();
    private static final SdkField<String> AUTHENTICATION_MATERIAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationMaterialType").getter(CreateManagedThingRequest.getter(CreateManagedThingRequest::authenticationMaterialTypeAsString)).setter(CreateManagedThingRequest.setter(Builder::authenticationMaterialType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMaterialType").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SerialNumber").getter(CreateManagedThingRequest.getter(CreateManagedThingRequest::serialNumber)).setter(CreateManagedThingRequest.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()}).build();
    private static final SdkField<String> BRAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Brand").getter(CreateManagedThingRequest.getter(CreateManagedThingRequest::brand)).setter(CreateManagedThingRequest.setter(Builder::brand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Brand").build()}).build();
    private static final SdkField<String> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Model").getter(CreateManagedThingRequest.getter(CreateManagedThingRequest::model)).setter(CreateManagedThingRequest.setter(Builder::model)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateManagedThingRequest.getter(CreateManagedThingRequest::name)).setter(CreateManagedThingRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<CapabilityReport> CAPABILITY_REPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapabilityReport").getter(CreateManagedThingRequest.getter(CreateManagedThingRequest::capabilityReport)).setter(CreateManagedThingRequest.setter(Builder::capabilityReport)).constructor(CapabilityReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapabilityReport").build()}).build();
    private static final SdkField<String> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Capabilities").getter(CreateManagedThingRequest.getter(CreateManagedThingRequest::capabilities)).setter(CreateManagedThingRequest.setter(Builder::capabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateManagedThingRequest.getter(CreateManagedThingRequest::clientToken)).setter(CreateManagedThingRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Classification").getter(CreateManagedThingRequest.getter(CreateManagedThingRequest::classification)).setter(CreateManagedThingRequest.setter(Builder::classification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateManagedThingRequest.getter(CreateManagedThingRequest::tags)).setter(CreateManagedThingRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> META_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("MetaData").getter(CreateManagedThingRequest.getter(CreateManagedThingRequest::metaData)).setter(CreateManagedThingRequest.setter(Builder::metaData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetaData").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_FIELD, OWNER_FIELD, CREDENTIAL_LOCKER_ID_FIELD, AUTHENTICATION_MATERIAL_FIELD, AUTHENTICATION_MATERIAL_TYPE_FIELD, SERIAL_NUMBER_FIELD, BRAND_FIELD, MODEL_FIELD, NAME_FIELD, CAPABILITY_REPORT_FIELD, CAPABILITIES_FIELD, CLIENT_TOKEN_FIELD, CLASSIFICATION_FIELD, TAGS_FIELD, META_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateManagedThingRequest.memberNameToFieldInitializer();
    private final String role;
    private final String owner;
    private final String credentialLockerId;
    private final String authenticationMaterial;
    private final String authenticationMaterialType;
    private final String serialNumber;
    private final String brand;
    private final String model;
    private final String name;
    private final CapabilityReport capabilityReport;
    private final String capabilities;
    private final String clientToken;
    private final String classification;
    private final Map<String, String> tags;
    private final Map<String, String> metaData;

    private CreateManagedThingRequest(BuilderImpl builder) {
        super(builder);
        this.role = builder.role;
        this.owner = builder.owner;
        this.credentialLockerId = builder.credentialLockerId;
        this.authenticationMaterial = builder.authenticationMaterial;
        this.authenticationMaterialType = builder.authenticationMaterialType;
        this.serialNumber = builder.serialNumber;
        this.brand = builder.brand;
        this.model = builder.model;
        this.name = builder.name;
        this.capabilityReport = builder.capabilityReport;
        this.capabilities = builder.capabilities;
        this.clientToken = builder.clientToken;
        this.classification = builder.classification;
        this.tags = builder.tags;
        this.metaData = builder.metaData;
    }

    public final Role role() {
        return Role.fromValue(this.role);
    }

    public final String roleAsString() {
        return this.role;
    }

    public final String owner() {
        return this.owner;
    }

    public final String credentialLockerId() {
        return this.credentialLockerId;
    }

    public final String authenticationMaterial() {
        return this.authenticationMaterial;
    }

    public final AuthMaterialType authenticationMaterialType() {
        return AuthMaterialType.fromValue(this.authenticationMaterialType);
    }

    public final String authenticationMaterialTypeAsString() {
        return this.authenticationMaterialType;
    }

    public final String serialNumber() {
        return this.serialNumber;
    }

    public final String brand() {
        return this.brand;
    }

    public final String model() {
        return this.model;
    }

    public final String name() {
        return this.name;
    }

    public final CapabilityReport capabilityReport() {
        return this.capabilityReport;
    }

    public final String capabilities() {
        return this.capabilities;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String classification() {
        return this.classification;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasMetaData() {
        return this.metaData != null && !(this.metaData instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metaData() {
        return this.metaData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialLockerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationMaterialTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.brand());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityReport());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilities());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.classification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetaData() ? this.metaData() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateManagedThingRequest)) {
            return false;
        }
        CreateManagedThingRequest other = (CreateManagedThingRequest)((Object)obj);
        return Objects.equals(this.roleAsString(), other.roleAsString()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.credentialLockerId(), other.credentialLockerId()) && Objects.equals(this.authenticationMaterial(), other.authenticationMaterial()) && Objects.equals(this.authenticationMaterialTypeAsString(), other.authenticationMaterialTypeAsString()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.brand(), other.brand()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.capabilityReport(), other.capabilityReport()) && Objects.equals(this.capabilities(), other.capabilities()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.classification(), other.classification()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasMetaData() == other.hasMetaData() && Objects.equals(this.metaData(), other.metaData());
    }

    public final String toString() {
        return ToString.builder((String)"CreateManagedThingRequest").add("Role", (Object)this.roleAsString()).add("Owner", (Object)(this.owner() == null ? null : "*** Sensitive Data Redacted ***")).add("CredentialLockerId", (Object)this.credentialLockerId()).add("AuthenticationMaterial", (Object)(this.authenticationMaterial() == null ? null : "*** Sensitive Data Redacted ***")).add("AuthenticationMaterialType", (Object)this.authenticationMaterialTypeAsString()).add("SerialNumber", (Object)(this.serialNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("Brand", (Object)(this.brand() == null ? null : "*** Sensitive Data Redacted ***")).add("Model", (Object)(this.model() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)this.name()).add("CapabilityReport", (Object)this.capabilityReport()).add("Capabilities", (Object)this.capabilities()).add("ClientToken", (Object)this.clientToken()).add("Classification", (Object)(this.classification() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("MetaData", this.hasMetaData() ? this.metaData() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "CredentialLockerId": {
                return Optional.ofNullable(clazz.cast(this.credentialLockerId()));
            }
            case "AuthenticationMaterial": {
                return Optional.ofNullable(clazz.cast(this.authenticationMaterial()));
            }
            case "AuthenticationMaterialType": {
                return Optional.ofNullable(clazz.cast(this.authenticationMaterialTypeAsString()));
            }
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "Brand": {
                return Optional.ofNullable(clazz.cast(this.brand()));
            }
            case "Model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CapabilityReport": {
                return Optional.ofNullable(clazz.cast(this.capabilityReport()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Classification": {
                return Optional.ofNullable(clazz.cast(this.classification()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "MetaData": {
                return Optional.ofNullable(clazz.cast(this.metaData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Role", ROLE_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("CredentialLockerId", CREDENTIAL_LOCKER_ID_FIELD);
        map.put("AuthenticationMaterial", AUTHENTICATION_MATERIAL_FIELD);
        map.put("AuthenticationMaterialType", AUTHENTICATION_MATERIAL_TYPE_FIELD);
        map.put("SerialNumber", SERIAL_NUMBER_FIELD);
        map.put("Brand", BRAND_FIELD);
        map.put("Model", MODEL_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("CapabilityReport", CAPABILITY_REPORT_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Classification", CLASSIFICATION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("MetaData", META_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateManagedThingRequest, T> g) {
        return obj -> g.apply((CreateManagedThingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsRequest.BuilderImpl
    implements Builder {
        private String role;
        private String owner;
        private String credentialLockerId;
        private String authenticationMaterial;
        private String authenticationMaterialType;
        private String serialNumber;
        private String brand;
        private String model;
        private String name;
        private CapabilityReport capabilityReport;
        private String capabilities;
        private String clientToken;
        private String classification;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> metaData = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateManagedThingRequest model) {
            super(model);
            this.role(model.role);
            this.owner(model.owner);
            this.credentialLockerId(model.credentialLockerId);
            this.authenticationMaterial(model.authenticationMaterial);
            this.authenticationMaterialType(model.authenticationMaterialType);
            this.serialNumber(model.serialNumber);
            this.brand(model.brand);
            this.model(model.model);
            this.name(model.name);
            this.capabilityReport(model.capabilityReport);
            this.capabilities(model.capabilities);
            this.clientToken(model.clientToken);
            this.classification(model.classification);
            this.tags(model.tags);
            this.metaData(model.metaData);
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(Role role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getCredentialLockerId() {
            return this.credentialLockerId;
        }

        public final void setCredentialLockerId(String credentialLockerId) {
            this.credentialLockerId = credentialLockerId;
        }

        @Override
        public final Builder credentialLockerId(String credentialLockerId) {
            this.credentialLockerId = credentialLockerId;
            return this;
        }

        public final String getAuthenticationMaterial() {
            return this.authenticationMaterial;
        }

        public final void setAuthenticationMaterial(String authenticationMaterial) {
            this.authenticationMaterial = authenticationMaterial;
        }

        @Override
        public final Builder authenticationMaterial(String authenticationMaterial) {
            this.authenticationMaterial = authenticationMaterial;
            return this;
        }

        public final String getAuthenticationMaterialType() {
            return this.authenticationMaterialType;
        }

        public final void setAuthenticationMaterialType(String authenticationMaterialType) {
            this.authenticationMaterialType = authenticationMaterialType;
        }

        @Override
        public final Builder authenticationMaterialType(String authenticationMaterialType) {
            this.authenticationMaterialType = authenticationMaterialType;
            return this;
        }

        @Override
        public final Builder authenticationMaterialType(AuthMaterialType authenticationMaterialType) {
            this.authenticationMaterialType(authenticationMaterialType == null ? null : authenticationMaterialType.toString());
            return this;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final String getBrand() {
            return this.brand;
        }

        public final void setBrand(String brand) {
            this.brand = brand;
        }

        @Override
        public final Builder brand(String brand) {
            this.brand = brand;
            return this;
        }

        public final String getModel() {
            return this.model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CapabilityReport.Builder getCapabilityReport() {
            return this.capabilityReport != null ? this.capabilityReport.toBuilder() : null;
        }

        public final void setCapabilityReport(CapabilityReport.BuilderImpl capabilityReport) {
            this.capabilityReport = capabilityReport != null ? capabilityReport.build() : null;
        }

        @Override
        public final Builder capabilityReport(CapabilityReport capabilityReport) {
            this.capabilityReport = capabilityReport;
            return this;
        }

        public final String getCapabilities() {
            return this.capabilities;
        }

        public final void setCapabilities(String capabilities) {
            this.capabilities = capabilities;
        }

        @Override
        public final Builder capabilities(String capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getClassification() {
            return this.classification;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final Map<String, String> getMetaData() {
            if (this.metaData instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metaData;
        }

        public final void setMetaData(Map<String, String> metaData) {
            this.metaData = MetaDataCopier.copy(metaData);
        }

        @Override
        public final Builder metaData(Map<String, String> metaData) {
            this.metaData = MetaDataCopier.copy(metaData);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateManagedThingRequest build() {
            return new CreateManagedThingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotManagedIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateManagedThingRequest> {
        public Builder role(String var1);

        public Builder role(Role var1);

        public Builder owner(String var1);

        public Builder credentialLockerId(String var1);

        public Builder authenticationMaterial(String var1);

        public Builder authenticationMaterialType(String var1);

        public Builder authenticationMaterialType(AuthMaterialType var1);

        public Builder serialNumber(String var1);

        public Builder brand(String var1);

        public Builder model(String var1);

        public Builder name(String var1);

        public Builder capabilityReport(CapabilityReport var1);

        default public Builder capabilityReport(Consumer<CapabilityReport.Builder> capabilityReport) {
            return this.capabilityReport((CapabilityReport)((CapabilityReport.Builder)CapabilityReport.builder().applyMutation(capabilityReport)).build());
        }

        public Builder capabilities(String var1);

        public Builder clientToken(String var1);

        public Builder classification(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder metaData(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

