/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DisconnectReasonValue {
    AUTH_ERROR("AUTH_ERROR"),
    CLIENT_INITIATED_DISCONNECT("CLIENT_INITIATED_DISCONNECT"),
    CLIENT_ERROR("CLIENT_ERROR"),
    CONNECTION_LOST("CONNECTION_LOST"),
    DUPLICATE_CLIENTID("DUPLICATE_CLIENTID"),
    FORBIDDEN_ACCESS("FORBIDDEN_ACCESS"),
    MQTT_KEEP_ALIVE_TIMEOUT("MQTT_KEEP_ALIVE_TIMEOUT"),
    SERVER_ERROR("SERVER_ERROR"),
    SERVER_INITIATED_DISCONNECT("SERVER_INITIATED_DISCONNECT"),
    THROTTLED("THROTTLED"),
    WEBSOCKET_TTL_EXPIRATION("WEBSOCKET_TTL_EXPIRATION"),
    CUSTOMAUTH_TTL_EXPIRATION("CUSTOMAUTH_TTL_EXPIRATION"),
    UNKNOWN("UNKNOWN"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DisconnectReasonValue> VALUE_MAP;
    private final String value;

    private DisconnectReasonValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DisconnectReasonValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DisconnectReasonValue> knownValues() {
        EnumSet<DisconnectReasonValue> knownValues = EnumSet.allOf(DisconnectReasonValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DisconnectReasonValue.class, DisconnectReasonValue::toString);
    }
}

