/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaMechanism;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaProtocol;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaStatus;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskExecutionRetryConfig;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskSchedulingConfig;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaType;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TargetCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TaskProcessingDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOtaTaskResponse
extends IotManagedIntegrationsResponse
implements ToCopyableBuilder<Builder, GetOtaTaskResponse> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskId").getter(GetOtaTaskResponse.getter(GetOtaTaskResponse::taskId)).setter(GetOtaTaskResponse.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()}).build();
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskArn").getter(GetOtaTaskResponse.getter(GetOtaTaskResponse::taskArn)).setter(GetOtaTaskResponse.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetOtaTaskResponse.getter(GetOtaTaskResponse::description)).setter(GetOtaTaskResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> S3_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Url").getter(GetOtaTaskResponse.getter(GetOtaTaskResponse::s3Url)).setter(GetOtaTaskResponse.setter(Builder::s3Url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Url").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(GetOtaTaskResponse.getter(GetOtaTaskResponse::protocolAsString)).setter(GetOtaTaskResponse.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<String> OTA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OtaType").getter(GetOtaTaskResponse.getter(GetOtaTaskResponse::otaTypeAsString)).setter(GetOtaTaskResponse.setter(Builder::otaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaType").build()}).build();
    private static final SdkField<String> OTA_TARGET_QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OtaTargetQueryString").getter(GetOtaTaskResponse.getter(GetOtaTaskResponse::otaTargetQueryString)).setter(GetOtaTaskResponse.setter(Builder::otaTargetQueryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaTargetQueryString").build()}).build();
    private static final SdkField<String> OTA_MECHANISM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OtaMechanism").getter(GetOtaTaskResponse.getter(GetOtaTaskResponse::otaMechanismAsString)).setter(GetOtaTaskResponse.setter(Builder::otaMechanism)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaMechanism").build()}).build();
    private static final SdkField<List<String>> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Target").getter(GetOtaTaskResponse.getter(GetOtaTaskResponse::target)).setter(GetOtaTaskResponse.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetOtaTaskResponse.getter(GetOtaTaskResponse::createdAt)).setter(GetOtaTaskResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(GetOtaTaskResponse.getter(GetOtaTaskResponse::lastUpdatedAt)).setter(GetOtaTaskResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<String> TASK_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskConfigurationId").getter(GetOtaTaskResponse.getter(GetOtaTaskResponse::taskConfigurationId)).setter(GetOtaTaskResponse.setter(Builder::taskConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskConfigurationId").build()}).build();
    private static final SdkField<TaskProcessingDetails> TASK_PROCESSING_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TaskProcessingDetails").getter(GetOtaTaskResponse.getter(GetOtaTaskResponse::taskProcessingDetails)).setter(GetOtaTaskResponse.setter(Builder::taskProcessingDetails)).constructor(TaskProcessingDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskProcessingDetails").build()}).build();
    private static final SdkField<OtaTaskSchedulingConfig> OTA_SCHEDULING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OtaSchedulingConfig").getter(GetOtaTaskResponse.getter(GetOtaTaskResponse::otaSchedulingConfig)).setter(GetOtaTaskResponse.setter(Builder::otaSchedulingConfig)).constructor(OtaTaskSchedulingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaSchedulingConfig").build()}).build();
    private static final SdkField<OtaTaskExecutionRetryConfig> OTA_TASK_EXECUTION_RETRY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OtaTaskExecutionRetryConfig").getter(GetOtaTaskResponse.getter(GetOtaTaskResponse::otaTaskExecutionRetryConfig)).setter(GetOtaTaskResponse.setter(Builder::otaTaskExecutionRetryConfig)).constructor(OtaTaskExecutionRetryConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaTaskExecutionRetryConfig").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetOtaTaskResponse.getter(GetOtaTaskResponse::statusAsString)).setter(GetOtaTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, TASK_ARN_FIELD, DESCRIPTION_FIELD, S3_URL_FIELD, PROTOCOL_FIELD, OTA_TYPE_FIELD, OTA_TARGET_QUERY_STRING_FIELD, OTA_MECHANISM_FIELD, TARGET_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, TASK_CONFIGURATION_ID_FIELD, TASK_PROCESSING_DETAILS_FIELD, OTA_SCHEDULING_CONFIG_FIELD, OTA_TASK_EXECUTION_RETRY_CONFIG_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetOtaTaskResponse.memberNameToFieldInitializer();
    private final String taskId;
    private final String taskArn;
    private final String description;
    private final String s3Url;
    private final String protocol;
    private final String otaType;
    private final String otaTargetQueryString;
    private final String otaMechanism;
    private final List<String> target;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String taskConfigurationId;
    private final TaskProcessingDetails taskProcessingDetails;
    private final OtaTaskSchedulingConfig otaSchedulingConfig;
    private final OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig;
    private final String status;

    private GetOtaTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.taskArn = builder.taskArn;
        this.description = builder.description;
        this.s3Url = builder.s3Url;
        this.protocol = builder.protocol;
        this.otaType = builder.otaType;
        this.otaTargetQueryString = builder.otaTargetQueryString;
        this.otaMechanism = builder.otaMechanism;
        this.target = builder.target;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.taskConfigurationId = builder.taskConfigurationId;
        this.taskProcessingDetails = builder.taskProcessingDetails;
        this.otaSchedulingConfig = builder.otaSchedulingConfig;
        this.otaTaskExecutionRetryConfig = builder.otaTaskExecutionRetryConfig;
        this.status = builder.status;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public final String description() {
        return this.description;
    }

    public final String s3Url() {
        return this.s3Url;
    }

    public final OtaProtocol protocol() {
        return OtaProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final OtaType otaType() {
        return OtaType.fromValue(this.otaType);
    }

    public final String otaTypeAsString() {
        return this.otaType;
    }

    public final String otaTargetQueryString() {
        return this.otaTargetQueryString;
    }

    public final OtaMechanism otaMechanism() {
        return OtaMechanism.fromValue(this.otaMechanism);
    }

    public final String otaMechanismAsString() {
        return this.otaMechanism;
    }

    public final boolean hasTarget() {
        return this.target != null && !(this.target instanceof SdkAutoConstructList);
    }

    public final List<String> target() {
        return this.target;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String taskConfigurationId() {
        return this.taskConfigurationId;
    }

    public final TaskProcessingDetails taskProcessingDetails() {
        return this.taskProcessingDetails;
    }

    public final OtaTaskSchedulingConfig otaSchedulingConfig() {
        return this.otaSchedulingConfig;
    }

    public final OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig() {
        return this.otaTaskExecutionRetryConfig;
    }

    public final OtaStatus status() {
        return OtaStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Url());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaTargetQueryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaMechanismAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTarget() ? this.target() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskProcessingDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaSchedulingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaTaskExecutionRetryConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOtaTaskResponse)) {
            return false;
        }
        GetOtaTaskResponse other = (GetOtaTaskResponse)((Object)obj);
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.s3Url(), other.s3Url()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.otaTypeAsString(), other.otaTypeAsString()) && Objects.equals(this.otaTargetQueryString(), other.otaTargetQueryString()) && Objects.equals(this.otaMechanismAsString(), other.otaMechanismAsString()) && this.hasTarget() == other.hasTarget() && Objects.equals(this.target(), other.target()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.taskConfigurationId(), other.taskConfigurationId()) && Objects.equals(this.taskProcessingDetails(), other.taskProcessingDetails()) && Objects.equals(this.otaSchedulingConfig(), other.otaSchedulingConfig()) && Objects.equals(this.otaTaskExecutionRetryConfig(), other.otaTaskExecutionRetryConfig()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetOtaTaskResponse").add("TaskId", (Object)this.taskId()).add("TaskArn", (Object)this.taskArn()).add("Description", (Object)this.description()).add("S3Url", (Object)this.s3Url()).add("Protocol", (Object)this.protocolAsString()).add("OtaType", (Object)this.otaTypeAsString()).add("OtaTargetQueryString", (Object)this.otaTargetQueryString()).add("OtaMechanism", (Object)this.otaMechanismAsString()).add("Target", this.hasTarget() ? this.target() : null).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("TaskConfigurationId", (Object)this.taskConfigurationId()).add("TaskProcessingDetails", (Object)this.taskProcessingDetails()).add("OtaSchedulingConfig", (Object)this.otaSchedulingConfig()).add("OtaTaskExecutionRetryConfig", (Object)this.otaTaskExecutionRetryConfig()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "TaskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "S3Url": {
                return Optional.ofNullable(clazz.cast(this.s3Url()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "OtaType": {
                return Optional.ofNullable(clazz.cast(this.otaTypeAsString()));
            }
            case "OtaTargetQueryString": {
                return Optional.ofNullable(clazz.cast(this.otaTargetQueryString()));
            }
            case "OtaMechanism": {
                return Optional.ofNullable(clazz.cast(this.otaMechanismAsString()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "TaskConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.taskConfigurationId()));
            }
            case "TaskProcessingDetails": {
                return Optional.ofNullable(clazz.cast(this.taskProcessingDetails()));
            }
            case "OtaSchedulingConfig": {
                return Optional.ofNullable(clazz.cast(this.otaSchedulingConfig()));
            }
            case "OtaTaskExecutionRetryConfig": {
                return Optional.ofNullable(clazz.cast(this.otaTaskExecutionRetryConfig()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TaskId", TASK_ID_FIELD);
        map.put("TaskArn", TASK_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("S3Url", S3_URL_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("OtaType", OTA_TYPE_FIELD);
        map.put("OtaTargetQueryString", OTA_TARGET_QUERY_STRING_FIELD);
        map.put("OtaMechanism", OTA_MECHANISM_FIELD);
        map.put("Target", TARGET_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("TaskConfigurationId", TASK_CONFIGURATION_ID_FIELD);
        map.put("TaskProcessingDetails", TASK_PROCESSING_DETAILS_FIELD);
        map.put("OtaSchedulingConfig", OTA_SCHEDULING_CONFIG_FIELD);
        map.put("OtaTaskExecutionRetryConfig", OTA_TASK_EXECUTION_RETRY_CONFIG_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOtaTaskResponse, T> g) {
        return obj -> g.apply((GetOtaTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsResponse.BuilderImpl
    implements Builder {
        private String taskId;
        private String taskArn;
        private String description;
        private String s3Url;
        private String protocol;
        private String otaType;
        private String otaTargetQueryString;
        private String otaMechanism;
        private List<String> target = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String taskConfigurationId;
        private TaskProcessingDetails taskProcessingDetails;
        private OtaTaskSchedulingConfig otaSchedulingConfig;
        private OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOtaTaskResponse model) {
            super(model);
            this.taskId(model.taskId);
            this.taskArn(model.taskArn);
            this.description(model.description);
            this.s3Url(model.s3Url);
            this.protocol(model.protocol);
            this.otaType(model.otaType);
            this.otaTargetQueryString(model.otaTargetQueryString);
            this.otaMechanism(model.otaMechanism);
            this.target(model.target);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.taskConfigurationId(model.taskConfigurationId);
            this.taskProcessingDetails(model.taskProcessingDetails);
            this.otaSchedulingConfig(model.otaSchedulingConfig);
            this.otaTaskExecutionRetryConfig(model.otaTaskExecutionRetryConfig);
            this.status(model.status);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getS3Url() {
            return this.s3Url;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(OtaProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getOtaType() {
            return this.otaType;
        }

        public final void setOtaType(String otaType) {
            this.otaType = otaType;
        }

        @Override
        public final Builder otaType(String otaType) {
            this.otaType = otaType;
            return this;
        }

        @Override
        public final Builder otaType(OtaType otaType) {
            this.otaType(otaType == null ? null : otaType.toString());
            return this;
        }

        public final String getOtaTargetQueryString() {
            return this.otaTargetQueryString;
        }

        public final void setOtaTargetQueryString(String otaTargetQueryString) {
            this.otaTargetQueryString = otaTargetQueryString;
        }

        @Override
        public final Builder otaTargetQueryString(String otaTargetQueryString) {
            this.otaTargetQueryString = otaTargetQueryString;
            return this;
        }

        public final String getOtaMechanism() {
            return this.otaMechanism;
        }

        public final void setOtaMechanism(String otaMechanism) {
            this.otaMechanism = otaMechanism;
        }

        @Override
        public final Builder otaMechanism(String otaMechanism) {
            this.otaMechanism = otaMechanism;
            return this;
        }

        @Override
        public final Builder otaMechanism(OtaMechanism otaMechanism) {
            this.otaMechanism(otaMechanism == null ? null : otaMechanism.toString());
            return this;
        }

        public final Collection<String> getTarget() {
            if (this.target instanceof SdkAutoConstructList) {
                return null;
            }
            return this.target;
        }

        public final void setTarget(Collection<String> target) {
            this.target = TargetCopier.copy(target);
        }

        @Override
        public final Builder target(Collection<String> target) {
            this.target = TargetCopier.copy(target);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder target(String ... target) {
            this.target(Arrays.asList(target));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getTaskConfigurationId() {
            return this.taskConfigurationId;
        }

        public final void setTaskConfigurationId(String taskConfigurationId) {
            this.taskConfigurationId = taskConfigurationId;
        }

        @Override
        public final Builder taskConfigurationId(String taskConfigurationId) {
            this.taskConfigurationId = taskConfigurationId;
            return this;
        }

        public final TaskProcessingDetails.Builder getTaskProcessingDetails() {
            return this.taskProcessingDetails != null ? this.taskProcessingDetails.toBuilder() : null;
        }

        public final void setTaskProcessingDetails(TaskProcessingDetails.BuilderImpl taskProcessingDetails) {
            this.taskProcessingDetails = taskProcessingDetails != null ? taskProcessingDetails.build() : null;
        }

        @Override
        public final Builder taskProcessingDetails(TaskProcessingDetails taskProcessingDetails) {
            this.taskProcessingDetails = taskProcessingDetails;
            return this;
        }

        public final OtaTaskSchedulingConfig.Builder getOtaSchedulingConfig() {
            return this.otaSchedulingConfig != null ? this.otaSchedulingConfig.toBuilder() : null;
        }

        public final void setOtaSchedulingConfig(OtaTaskSchedulingConfig.BuilderImpl otaSchedulingConfig) {
            this.otaSchedulingConfig = otaSchedulingConfig != null ? otaSchedulingConfig.build() : null;
        }

        @Override
        public final Builder otaSchedulingConfig(OtaTaskSchedulingConfig otaSchedulingConfig) {
            this.otaSchedulingConfig = otaSchedulingConfig;
            return this;
        }

        public final OtaTaskExecutionRetryConfig.Builder getOtaTaskExecutionRetryConfig() {
            return this.otaTaskExecutionRetryConfig != null ? this.otaTaskExecutionRetryConfig.toBuilder() : null;
        }

        public final void setOtaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig.BuilderImpl otaTaskExecutionRetryConfig) {
            this.otaTaskExecutionRetryConfig = otaTaskExecutionRetryConfig != null ? otaTaskExecutionRetryConfig.build() : null;
        }

        @Override
        public final Builder otaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig) {
            this.otaTaskExecutionRetryConfig = otaTaskExecutionRetryConfig;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OtaStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetOtaTaskResponse build() {
            return new GetOtaTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotManagedIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOtaTaskResponse> {
        public Builder taskId(String var1);

        public Builder taskArn(String var1);

        public Builder description(String var1);

        public Builder s3Url(String var1);

        public Builder protocol(String var1);

        public Builder protocol(OtaProtocol var1);

        public Builder otaType(String var1);

        public Builder otaType(OtaType var1);

        public Builder otaTargetQueryString(String var1);

        public Builder otaMechanism(String var1);

        public Builder otaMechanism(OtaMechanism var1);

        public Builder target(Collection<String> var1);

        public Builder target(String ... var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder taskConfigurationId(String var1);

        public Builder taskProcessingDetails(TaskProcessingDetails var1);

        default public Builder taskProcessingDetails(Consumer<TaskProcessingDetails.Builder> taskProcessingDetails) {
            return this.taskProcessingDetails((TaskProcessingDetails)((TaskProcessingDetails.Builder)TaskProcessingDetails.builder().applyMutation(taskProcessingDetails)).build());
        }

        public Builder otaSchedulingConfig(OtaTaskSchedulingConfig var1);

        default public Builder otaSchedulingConfig(Consumer<OtaTaskSchedulingConfig.Builder> otaSchedulingConfig) {
            return this.otaSchedulingConfig((OtaTaskSchedulingConfig)((OtaTaskSchedulingConfig.Builder)OtaTaskSchedulingConfig.builder().applyMutation(otaSchedulingConfig)).build());
        }

        public Builder otaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig var1);

        default public Builder otaTaskExecutionRetryConfig(Consumer<OtaTaskExecutionRetryConfig.Builder> otaTaskExecutionRetryConfig) {
            return this.otaTaskExecutionRetryConfig((OtaTaskExecutionRetryConfig)((OtaTaskExecutionRetryConfig.Builder)OtaTaskExecutionRetryConfig.builder().applyMutation(otaTaskExecutionRetryConfig)).build());
        }

        public Builder status(String var1);

        public Builder status(OtaStatus var1);
    }
}

