/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotmanagedintegrations.model.EventLogConfigurationListDefinitionCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.EventLogConfigurationSummary;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEventLogConfigurationsResponse
extends IotManagedIntegrationsResponse
implements ToCopyableBuilder<Builder, ListEventLogConfigurationsResponse> {
    private static final SdkField<List<EventLogConfigurationSummary>> EVENT_LOG_CONFIGURATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventLogConfigurationList").getter(ListEventLogConfigurationsResponse.getter(ListEventLogConfigurationsResponse::eventLogConfigurationList)).setter(ListEventLogConfigurationsResponse.setter(Builder::eventLogConfigurationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventLogConfigurationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventLogConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEventLogConfigurationsResponse.getter(ListEventLogConfigurationsResponse::nextToken)).setter(ListEventLogConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_LOG_CONFIGURATION_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEventLogConfigurationsResponse.memberNameToFieldInitializer();
    private final List<EventLogConfigurationSummary> eventLogConfigurationList;
    private final String nextToken;

    private ListEventLogConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.eventLogConfigurationList = builder.eventLogConfigurationList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEventLogConfigurationList() {
        return this.eventLogConfigurationList != null && !(this.eventLogConfigurationList instanceof SdkAutoConstructList);
    }

    public final List<EventLogConfigurationSummary> eventLogConfigurationList() {
        return this.eventLogConfigurationList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventLogConfigurationList() ? this.eventLogConfigurationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventLogConfigurationsResponse)) {
            return false;
        }
        ListEventLogConfigurationsResponse other = (ListEventLogConfigurationsResponse)((Object)obj);
        return this.hasEventLogConfigurationList() == other.hasEventLogConfigurationList() && Objects.equals(this.eventLogConfigurationList(), other.eventLogConfigurationList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEventLogConfigurationsResponse").add("EventLogConfigurationList", this.hasEventLogConfigurationList() ? this.eventLogConfigurationList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventLogConfigurationList": {
                return Optional.ofNullable(clazz.cast(this.eventLogConfigurationList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventLogConfigurationList", EVENT_LOG_CONFIGURATION_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEventLogConfigurationsResponse, T> g) {
        return obj -> g.apply((ListEventLogConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsResponse.BuilderImpl
    implements Builder {
        private List<EventLogConfigurationSummary> eventLogConfigurationList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventLogConfigurationsResponse model) {
            super(model);
            this.eventLogConfigurationList(model.eventLogConfigurationList);
            this.nextToken(model.nextToken);
        }

        public final List<EventLogConfigurationSummary.Builder> getEventLogConfigurationList() {
            List<EventLogConfigurationSummary.Builder> result = EventLogConfigurationListDefinitionCopier.copyToBuilder(this.eventLogConfigurationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventLogConfigurationList(Collection<EventLogConfigurationSummary.BuilderImpl> eventLogConfigurationList) {
            this.eventLogConfigurationList = EventLogConfigurationListDefinitionCopier.copyFromBuilder(eventLogConfigurationList);
        }

        @Override
        public final Builder eventLogConfigurationList(Collection<EventLogConfigurationSummary> eventLogConfigurationList) {
            this.eventLogConfigurationList = EventLogConfigurationListDefinitionCopier.copy(eventLogConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventLogConfigurationList(EventLogConfigurationSummary ... eventLogConfigurationList) {
            this.eventLogConfigurationList(Arrays.asList(eventLogConfigurationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventLogConfigurationList(Consumer<EventLogConfigurationSummary.Builder> ... eventLogConfigurationList) {
            this.eventLogConfigurationList(Stream.of(eventLogConfigurationList).map(c -> (EventLogConfigurationSummary)((EventLogConfigurationSummary.Builder)EventLogConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEventLogConfigurationsResponse build() {
            return new ListEventLogConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotManagedIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEventLogConfigurationsResponse> {
        public Builder eventLogConfigurationList(Collection<EventLogConfigurationSummary> var1);

        public Builder eventLogConfigurationList(EventLogConfigurationSummary ... var1);

        public Builder eventLogConfigurationList(Consumer<EventLogConfigurationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

