/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OtaMechanism {
    PUSH("PUSH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OtaMechanism> VALUE_MAP;
    private final String value;

    private OtaMechanism(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OtaMechanism fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OtaMechanism> knownValues() {
        EnumSet<OtaMechanism> knownValues = EnumSet.allOf(OtaMechanism.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OtaMechanism.class, OtaMechanism::toString);
    }
}

