/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OtaTaskSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OtaTaskSummary> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskId").getter(OtaTaskSummary.getter(OtaTaskSummary::taskId)).setter(OtaTaskSummary.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()}).build();
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskArn").getter(OtaTaskSummary.getter(OtaTaskSummary::taskArn)).setter(OtaTaskSummary.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(OtaTaskSummary.getter(OtaTaskSummary::createdAt)).setter(OtaTaskSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(OtaTaskSummary.getter(OtaTaskSummary::lastUpdatedAt)).setter(OtaTaskSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<String> TASK_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskConfigurationId").getter(OtaTaskSummary.getter(OtaTaskSummary::taskConfigurationId)).setter(OtaTaskSummary.setter(Builder::taskConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskConfigurationId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(OtaTaskSummary.getter(OtaTaskSummary::statusAsString)).setter(OtaTaskSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, TASK_ARN_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, TASK_CONFIGURATION_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OtaTaskSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String taskId;
    private final String taskArn;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String taskConfigurationId;
    private final String status;

    private OtaTaskSummary(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.taskArn = builder.taskArn;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.taskConfigurationId = builder.taskConfigurationId;
        this.status = builder.status;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String taskConfigurationId() {
        return this.taskConfigurationId;
    }

    public final OtaStatus status() {
        return OtaStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OtaTaskSummary)) {
            return false;
        }
        OtaTaskSummary other = (OtaTaskSummary)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.taskConfigurationId(), other.taskConfigurationId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OtaTaskSummary").add("TaskId", (Object)this.taskId()).add("TaskArn", (Object)this.taskArn()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("TaskConfigurationId", (Object)this.taskConfigurationId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "TaskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "TaskConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.taskConfigurationId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TaskId", TASK_ID_FIELD);
        map.put("TaskArn", TASK_ARN_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("TaskConfigurationId", TASK_CONFIGURATION_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OtaTaskSummary, T> g) {
        return obj -> g.apply((OtaTaskSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String taskArn;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String taskConfigurationId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(OtaTaskSummary model) {
            this.taskId(model.taskId);
            this.taskArn(model.taskArn);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.taskConfigurationId(model.taskConfigurationId);
            this.status(model.status);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getTaskConfigurationId() {
            return this.taskConfigurationId;
        }

        public final void setTaskConfigurationId(String taskConfigurationId) {
            this.taskConfigurationId = taskConfigurationId;
        }

        @Override
        public final Builder taskConfigurationId(String taskConfigurationId) {
            this.taskConfigurationId = taskConfigurationId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OtaStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public OtaTaskSummary build() {
            return new OtaTaskSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OtaTaskSummary> {
        public Builder taskId(String var1);

        public Builder taskArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder taskConfigurationId(String var1);

        public Builder status(String var1);

        public Builder status(OtaStatus var1);
    }
}

