/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotmanagedintegrations.model.StateCapabilitiesCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.StateCapability;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StateEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StateEndpoint> {
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpointId").getter(StateEndpoint.getter(StateEndpoint::endpointId)).setter(StateEndpoint.setter(Builder::endpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointId").build()}).build();
    private static final SdkField<List<StateCapability>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capabilities").getter(StateEndpoint.getter(StateEndpoint::capabilities)).setter(StateEndpoint.setter(Builder::capabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StateCapability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ID_FIELD, CAPABILITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StateEndpoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String endpointId;
    private final List<StateCapability> capabilities;

    private StateEndpoint(BuilderImpl builder) {
        this.endpointId = builder.endpointId;
        this.capabilities = builder.capabilities;
    }

    public final String endpointId() {
        return this.endpointId;
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<StateCapability> capabilities() {
        return this.capabilities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StateEndpoint)) {
            return false;
        }
        StateEndpoint other = (StateEndpoint)obj;
        return Objects.equals(this.endpointId(), other.endpointId()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilities(), other.capabilities());
    }

    public final String toString() {
        return ToString.builder((String)"StateEndpoint").add("EndpointId", (Object)this.endpointId()).add("Capabilities", this.hasCapabilities() ? this.capabilities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endpointId": {
                return Optional.ofNullable(clazz.cast(this.endpointId()));
            }
            case "capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("endpointId", ENDPOINT_ID_FIELD);
        map.put("capabilities", CAPABILITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StateEndpoint, T> g) {
        return obj -> g.apply((StateEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointId;
        private List<StateCapability> capabilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StateEndpoint model) {
            this.endpointId(model.endpointId);
            this.capabilities(model.capabilities);
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final List<StateCapability.Builder> getCapabilities() {
            List<StateCapability.Builder> result = StateCapabilitiesCopier.copyToBuilder(this.capabilities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapabilities(Collection<StateCapability.BuilderImpl> capabilities) {
            this.capabilities = StateCapabilitiesCopier.copyFromBuilder(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<StateCapability> capabilities) {
            this.capabilities = StateCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(StateCapability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Consumer<StateCapability.Builder> ... capabilities) {
            this.capabilities(Stream.of(capabilities).map(c -> (StateCapability)((StateCapability.Builder)StateCapability.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public StateEndpoint build() {
            return new StateEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StateEndpoint> {
        public Builder endpointId(String var1);

        public Builder capabilities(Collection<StateCapability> var1);

        public Builder capabilities(StateCapability ... var1);

        public Builder capabilities(Consumer<StateCapability.Builder> ... var1);
    }
}

