/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CredentialLockerSummary;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersResponse;

public class ListCredentialLockersIterable
implements SdkIterable<ListCredentialLockersResponse> {
    private final IotManagedIntegrationsClient client;
    private final ListCredentialLockersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCredentialLockersIterable(IotManagedIntegrationsClient client, ListCredentialLockersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCredentialLockersResponseFetcher();
    }

    public Iterator<ListCredentialLockersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CredentialLockerSummary> items() {
        Function<ListCredentialLockersResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCredentialLockersResponseFetcher
    implements SyncPageFetcher<ListCredentialLockersResponse> {
        private ListCredentialLockersResponseFetcher() {
        }

        public boolean hasNextPage(ListCredentialLockersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCredentialLockersResponse nextPage(ListCredentialLockersResponse previousPage) {
            if (previousPage == null) {
                return ListCredentialLockersIterable.this.client.listCredentialLockers(ListCredentialLockersIterable.this.firstRequest);
            }
            return ListCredentialLockersIterable.this.client.listCredentialLockers((ListCredentialLockersRequest)((Object)ListCredentialLockersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

