/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DestinationSummary;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsResponse;

public class ListDestinationsIterable
implements SdkIterable<ListDestinationsResponse> {
    private final IotManagedIntegrationsClient client;
    private final ListDestinationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDestinationsIterable(IotManagedIntegrationsClient client, ListDestinationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDestinationsResponseFetcher();
    }

    public Iterator<ListDestinationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DestinationSummary> destinationList() {
        Function<ListDestinationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.destinationList() != null) {
                return response.destinationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDestinationsResponseFetcher
    implements SyncPageFetcher<ListDestinationsResponse> {
        private ListDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDestinationsResponse nextPage(ListDestinationsResponse previousPage) {
            if (previousPage == null) {
                return ListDestinationsIterable.this.client.listDestinations(ListDestinationsIterable.this.firstRequest);
            }
            return ListDestinationsIterable.this.client.listDestinations((ListDestinationsRequest)((Object)ListDestinationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

