/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsAsyncClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskSummary;

public class ListOtaTasksPublisher
implements SdkPublisher<ListOtaTasksResponse> {
    private final IotManagedIntegrationsAsyncClient client;
    private final ListOtaTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOtaTasksPublisher(IotManagedIntegrationsAsyncClient client, ListOtaTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOtaTasksPublisher(IotManagedIntegrationsAsyncClient client, ListOtaTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOtaTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOtaTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OtaTaskSummary> tasks() {
        Function<ListOtaTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tasks() != null) {
                return response.tasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOtaTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOtaTasksResponseFetcher
    implements AsyncPageFetcher<ListOtaTasksResponse> {
        private ListOtaTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListOtaTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOtaTasksResponse> nextPage(ListOtaTasksResponse previousPage) {
            if (previousPage == null) {
                return ListOtaTasksPublisher.this.client.listOtaTasks(ListOtaTasksPublisher.this.firstRequest);
            }
            return ListOtaTasksPublisher.this.client.listOtaTasks((ListOtaTasksRequest)((Object)ListOtaTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

