/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilityReportCapabilitiesCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilityReportCapability;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeviceTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapabilityReportEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapabilityReportEndpoint> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CapabilityReportEndpoint.getter(CapabilityReportEndpoint::id)).setter(CapabilityReportEndpoint.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<String>> DEVICE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deviceTypes").getter(CapabilityReportEndpoint.getter(CapabilityReportEndpoint::deviceTypes)).setter(CapabilityReportEndpoint.setter(Builder::deviceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CapabilityReportCapability>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capabilities").getter(CapabilityReportEndpoint.getter(CapabilityReportEndpoint::capabilities)).setter(CapabilityReportEndpoint.setter(Builder::capabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapabilityReportCapability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DEVICE_TYPES_FIELD, CAPABILITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapabilityReportEndpoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final List<String> deviceTypes;
    private final List<CapabilityReportCapability> capabilities;

    private CapabilityReportEndpoint(BuilderImpl builder) {
        this.id = builder.id;
        this.deviceTypes = builder.deviceTypes;
        this.capabilities = builder.capabilities;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasDeviceTypes() {
        return this.deviceTypes != null && !(this.deviceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> deviceTypes() {
        return this.deviceTypes;
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<CapabilityReportCapability> capabilities() {
        return this.capabilities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceTypes() ? this.deviceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapabilityReportEndpoint)) {
            return false;
        }
        CapabilityReportEndpoint other = (CapabilityReportEndpoint)obj;
        return Objects.equals(this.id(), other.id()) && this.hasDeviceTypes() == other.hasDeviceTypes() && Objects.equals(this.deviceTypes(), other.deviceTypes()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilities(), other.capabilities());
    }

    public final String toString() {
        return ToString.builder((String)"CapabilityReportEndpoint").add("Id", (Object)this.id()).add("DeviceTypes", this.hasDeviceTypes() ? this.deviceTypes() : null).add("Capabilities", this.hasCapabilities() ? this.capabilities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "deviceTypes": {
                return Optional.ofNullable(clazz.cast(this.deviceTypes()));
            }
            case "capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("deviceTypes", DEVICE_TYPES_FIELD);
        map.put("capabilities", CAPABILITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapabilityReportEndpoint, T> g) {
        return obj -> g.apply((CapabilityReportEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<String> deviceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<CapabilityReportCapability> capabilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapabilityReportEndpoint model) {
            this.id(model.id);
            this.deviceTypes(model.deviceTypes);
            this.capabilities(model.capabilities);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<String> getDeviceTypes() {
            if (this.deviceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deviceTypes;
        }

        public final void setDeviceTypes(Collection<String> deviceTypes) {
            this.deviceTypes = DeviceTypesCopier.copy(deviceTypes);
        }

        @Override
        public final Builder deviceTypes(Collection<String> deviceTypes) {
            this.deviceTypes = DeviceTypesCopier.copy(deviceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceTypes(String ... deviceTypes) {
            this.deviceTypes(Arrays.asList(deviceTypes));
            return this;
        }

        public final List<CapabilityReportCapability.Builder> getCapabilities() {
            List<CapabilityReportCapability.Builder> result = CapabilityReportCapabilitiesCopier.copyToBuilder(this.capabilities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapabilities(Collection<CapabilityReportCapability.BuilderImpl> capabilities) {
            this.capabilities = CapabilityReportCapabilitiesCopier.copyFromBuilder(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<CapabilityReportCapability> capabilities) {
            this.capabilities = CapabilityReportCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(CapabilityReportCapability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Consumer<CapabilityReportCapability.Builder> ... capabilities) {
            this.capabilities(Stream.of(capabilities).map(c -> (CapabilityReportCapability)((CapabilityReportCapability.Builder)CapabilityReportCapability.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CapabilityReportEndpoint build() {
            return new CapabilityReportEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapabilityReportEndpoint> {
        public Builder id(String var1);

        public Builder deviceTypes(Collection<String> var1);

        public Builder deviceTypes(String ... var1);

        public Builder capabilities(Collection<CapabilityReportCapability> var1);

        public Builder capabilities(CapabilityReportCapability ... var1);

        public Builder capabilities(Consumer<CapabilityReportCapability.Builder> ... var1);
    }
}

