/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaMechanism;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaProtocol;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskExecutionRetryConfig;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskSchedulingConfig;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaType;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TagsMapCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TargetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOtaTaskRequest
extends IotManagedIntegrationsRequest
implements ToCopyableBuilder<Builder, CreateOtaTaskRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateOtaTaskRequest.getter(CreateOtaTaskRequest::description)).setter(CreateOtaTaskRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> S3_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Url").getter(CreateOtaTaskRequest.getter(CreateOtaTaskRequest::s3Url)).setter(CreateOtaTaskRequest.setter(Builder::s3Url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Url").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(CreateOtaTaskRequest.getter(CreateOtaTaskRequest::protocolAsString)).setter(CreateOtaTaskRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<List<String>> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Target").getter(CreateOtaTaskRequest.getter(CreateOtaTaskRequest::target)).setter(CreateOtaTaskRequest.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TASK_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskConfigurationId").getter(CreateOtaTaskRequest.getter(CreateOtaTaskRequest::taskConfigurationId)).setter(CreateOtaTaskRequest.setter(Builder::taskConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskConfigurationId").build()}).build();
    private static final SdkField<String> OTA_MECHANISM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OtaMechanism").getter(CreateOtaTaskRequest.getter(CreateOtaTaskRequest::otaMechanismAsString)).setter(CreateOtaTaskRequest.setter(Builder::otaMechanism)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaMechanism").build()}).build();
    private static final SdkField<String> OTA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OtaType").getter(CreateOtaTaskRequest.getter(CreateOtaTaskRequest::otaTypeAsString)).setter(CreateOtaTaskRequest.setter(Builder::otaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaType").build()}).build();
    private static final SdkField<String> OTA_TARGET_QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OtaTargetQueryString").getter(CreateOtaTaskRequest.getter(CreateOtaTaskRequest::otaTargetQueryString)).setter(CreateOtaTaskRequest.setter(Builder::otaTargetQueryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaTargetQueryString").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateOtaTaskRequest.getter(CreateOtaTaskRequest::clientToken)).setter(CreateOtaTaskRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<OtaTaskSchedulingConfig> OTA_SCHEDULING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OtaSchedulingConfig").getter(CreateOtaTaskRequest.getter(CreateOtaTaskRequest::otaSchedulingConfig)).setter(CreateOtaTaskRequest.setter(Builder::otaSchedulingConfig)).constructor(OtaTaskSchedulingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaSchedulingConfig").build()}).build();
    private static final SdkField<OtaTaskExecutionRetryConfig> OTA_TASK_EXECUTION_RETRY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OtaTaskExecutionRetryConfig").getter(CreateOtaTaskRequest.getter(CreateOtaTaskRequest::otaTaskExecutionRetryConfig)).setter(CreateOtaTaskRequest.setter(Builder::otaTaskExecutionRetryConfig)).constructor(OtaTaskExecutionRetryConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaTaskExecutionRetryConfig").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateOtaTaskRequest.getter(CreateOtaTaskRequest::tags)).setter(CreateOtaTaskRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, S3_URL_FIELD, PROTOCOL_FIELD, TARGET_FIELD, TASK_CONFIGURATION_ID_FIELD, OTA_MECHANISM_FIELD, OTA_TYPE_FIELD, OTA_TARGET_QUERY_STRING_FIELD, CLIENT_TOKEN_FIELD, OTA_SCHEDULING_CONFIG_FIELD, OTA_TASK_EXECUTION_RETRY_CONFIG_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateOtaTaskRequest.memberNameToFieldInitializer();
    private final String description;
    private final String s3Url;
    private final String protocol;
    private final List<String> target;
    private final String taskConfigurationId;
    private final String otaMechanism;
    private final String otaType;
    private final String otaTargetQueryString;
    private final String clientToken;
    private final OtaTaskSchedulingConfig otaSchedulingConfig;
    private final OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig;
    private final Map<String, String> tags;

    private CreateOtaTaskRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.s3Url = builder.s3Url;
        this.protocol = builder.protocol;
        this.target = builder.target;
        this.taskConfigurationId = builder.taskConfigurationId;
        this.otaMechanism = builder.otaMechanism;
        this.otaType = builder.otaType;
        this.otaTargetQueryString = builder.otaTargetQueryString;
        this.clientToken = builder.clientToken;
        this.otaSchedulingConfig = builder.otaSchedulingConfig;
        this.otaTaskExecutionRetryConfig = builder.otaTaskExecutionRetryConfig;
        this.tags = builder.tags;
    }

    public final String description() {
        return this.description;
    }

    public final String s3Url() {
        return this.s3Url;
    }

    public final OtaProtocol protocol() {
        return OtaProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final boolean hasTarget() {
        return this.target != null && !(this.target instanceof SdkAutoConstructList);
    }

    public final List<String> target() {
        return this.target;
    }

    public final String taskConfigurationId() {
        return this.taskConfigurationId;
    }

    public final OtaMechanism otaMechanism() {
        return OtaMechanism.fromValue(this.otaMechanism);
    }

    public final String otaMechanismAsString() {
        return this.otaMechanism;
    }

    public final OtaType otaType() {
        return OtaType.fromValue(this.otaType);
    }

    public final String otaTypeAsString() {
        return this.otaType;
    }

    public final String otaTargetQueryString() {
        return this.otaTargetQueryString;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final OtaTaskSchedulingConfig otaSchedulingConfig() {
        return this.otaSchedulingConfig;
    }

    public final OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig() {
        return this.otaTaskExecutionRetryConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Url());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTarget() ? this.target() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.taskConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaMechanismAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaTargetQueryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaSchedulingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaTaskExecutionRetryConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOtaTaskRequest)) {
            return false;
        }
        CreateOtaTaskRequest other = (CreateOtaTaskRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.s3Url(), other.s3Url()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && this.hasTarget() == other.hasTarget() && Objects.equals(this.target(), other.target()) && Objects.equals(this.taskConfigurationId(), other.taskConfigurationId()) && Objects.equals(this.otaMechanismAsString(), other.otaMechanismAsString()) && Objects.equals(this.otaTypeAsString(), other.otaTypeAsString()) && Objects.equals(this.otaTargetQueryString(), other.otaTargetQueryString()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.otaSchedulingConfig(), other.otaSchedulingConfig()) && Objects.equals(this.otaTaskExecutionRetryConfig(), other.otaTaskExecutionRetryConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOtaTaskRequest").add("Description", (Object)this.description()).add("S3Url", (Object)this.s3Url()).add("Protocol", (Object)this.protocolAsString()).add("Target", this.hasTarget() ? this.target() : null).add("TaskConfigurationId", (Object)this.taskConfigurationId()).add("OtaMechanism", (Object)this.otaMechanismAsString()).add("OtaType", (Object)this.otaTypeAsString()).add("OtaTargetQueryString", (Object)this.otaTargetQueryString()).add("ClientToken", (Object)this.clientToken()).add("OtaSchedulingConfig", (Object)this.otaSchedulingConfig()).add("OtaTaskExecutionRetryConfig", (Object)this.otaTaskExecutionRetryConfig()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "S3Url": {
                return Optional.ofNullable(clazz.cast(this.s3Url()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "TaskConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.taskConfigurationId()));
            }
            case "OtaMechanism": {
                return Optional.ofNullable(clazz.cast(this.otaMechanismAsString()));
            }
            case "OtaType": {
                return Optional.ofNullable(clazz.cast(this.otaTypeAsString()));
            }
            case "OtaTargetQueryString": {
                return Optional.ofNullable(clazz.cast(this.otaTargetQueryString()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "OtaSchedulingConfig": {
                return Optional.ofNullable(clazz.cast(this.otaSchedulingConfig()));
            }
            case "OtaTaskExecutionRetryConfig": {
                return Optional.ofNullable(clazz.cast(this.otaTaskExecutionRetryConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("S3Url", S3_URL_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("Target", TARGET_FIELD);
        map.put("TaskConfigurationId", TASK_CONFIGURATION_ID_FIELD);
        map.put("OtaMechanism", OTA_MECHANISM_FIELD);
        map.put("OtaType", OTA_TYPE_FIELD);
        map.put("OtaTargetQueryString", OTA_TARGET_QUERY_STRING_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("OtaSchedulingConfig", OTA_SCHEDULING_CONFIG_FIELD);
        map.put("OtaTaskExecutionRetryConfig", OTA_TASK_EXECUTION_RETRY_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOtaTaskRequest, T> g) {
        return obj -> g.apply((CreateOtaTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsRequest.BuilderImpl
    implements Builder {
        private String description;
        private String s3Url;
        private String protocol;
        private List<String> target = DefaultSdkAutoConstructList.getInstance();
        private String taskConfigurationId;
        private String otaMechanism;
        private String otaType;
        private String otaTargetQueryString;
        private String clientToken;
        private OtaTaskSchedulingConfig otaSchedulingConfig;
        private OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOtaTaskRequest model) {
            super(model);
            this.description(model.description);
            this.s3Url(model.s3Url);
            this.protocol(model.protocol);
            this.target(model.target);
            this.taskConfigurationId(model.taskConfigurationId);
            this.otaMechanism(model.otaMechanism);
            this.otaType(model.otaType);
            this.otaTargetQueryString(model.otaTargetQueryString);
            this.clientToken(model.clientToken);
            this.otaSchedulingConfig(model.otaSchedulingConfig);
            this.otaTaskExecutionRetryConfig(model.otaTaskExecutionRetryConfig);
            this.tags(model.tags);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getS3Url() {
            return this.s3Url;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(OtaProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Collection<String> getTarget() {
            if (this.target instanceof SdkAutoConstructList) {
                return null;
            }
            return this.target;
        }

        public final void setTarget(Collection<String> target) {
            this.target = TargetCopier.copy(target);
        }

        @Override
        public final Builder target(Collection<String> target) {
            this.target = TargetCopier.copy(target);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder target(String ... target) {
            this.target(Arrays.asList(target));
            return this;
        }

        public final String getTaskConfigurationId() {
            return this.taskConfigurationId;
        }

        public final void setTaskConfigurationId(String taskConfigurationId) {
            this.taskConfigurationId = taskConfigurationId;
        }

        @Override
        public final Builder taskConfigurationId(String taskConfigurationId) {
            this.taskConfigurationId = taskConfigurationId;
            return this;
        }

        public final String getOtaMechanism() {
            return this.otaMechanism;
        }

        public final void setOtaMechanism(String otaMechanism) {
            this.otaMechanism = otaMechanism;
        }

        @Override
        public final Builder otaMechanism(String otaMechanism) {
            this.otaMechanism = otaMechanism;
            return this;
        }

        @Override
        public final Builder otaMechanism(OtaMechanism otaMechanism) {
            this.otaMechanism(otaMechanism == null ? null : otaMechanism.toString());
            return this;
        }

        public final String getOtaType() {
            return this.otaType;
        }

        public final void setOtaType(String otaType) {
            this.otaType = otaType;
        }

        @Override
        public final Builder otaType(String otaType) {
            this.otaType = otaType;
            return this;
        }

        @Override
        public final Builder otaType(OtaType otaType) {
            this.otaType(otaType == null ? null : otaType.toString());
            return this;
        }

        public final String getOtaTargetQueryString() {
            return this.otaTargetQueryString;
        }

        public final void setOtaTargetQueryString(String otaTargetQueryString) {
            this.otaTargetQueryString = otaTargetQueryString;
        }

        @Override
        public final Builder otaTargetQueryString(String otaTargetQueryString) {
            this.otaTargetQueryString = otaTargetQueryString;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final OtaTaskSchedulingConfig.Builder getOtaSchedulingConfig() {
            return this.otaSchedulingConfig != null ? this.otaSchedulingConfig.toBuilder() : null;
        }

        public final void setOtaSchedulingConfig(OtaTaskSchedulingConfig.BuilderImpl otaSchedulingConfig) {
            this.otaSchedulingConfig = otaSchedulingConfig != null ? otaSchedulingConfig.build() : null;
        }

        @Override
        public final Builder otaSchedulingConfig(OtaTaskSchedulingConfig otaSchedulingConfig) {
            this.otaSchedulingConfig = otaSchedulingConfig;
            return this;
        }

        public final OtaTaskExecutionRetryConfig.Builder getOtaTaskExecutionRetryConfig() {
            return this.otaTaskExecutionRetryConfig != null ? this.otaTaskExecutionRetryConfig.toBuilder() : null;
        }

        public final void setOtaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig.BuilderImpl otaTaskExecutionRetryConfig) {
            this.otaTaskExecutionRetryConfig = otaTaskExecutionRetryConfig != null ? otaTaskExecutionRetryConfig.build() : null;
        }

        @Override
        public final Builder otaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig) {
            this.otaTaskExecutionRetryConfig = otaTaskExecutionRetryConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOtaTaskRequest build() {
            return new CreateOtaTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotManagedIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOtaTaskRequest> {
        public Builder description(String var1);

        public Builder s3Url(String var1);

        public Builder protocol(String var1);

        public Builder protocol(OtaProtocol var1);

        public Builder target(Collection<String> var1);

        public Builder target(String ... var1);

        public Builder taskConfigurationId(String var1);

        public Builder otaMechanism(String var1);

        public Builder otaMechanism(OtaMechanism var1);

        public Builder otaType(String var1);

        public Builder otaType(OtaType var1);

        public Builder otaTargetQueryString(String var1);

        public Builder clientToken(String var1);

        public Builder otaSchedulingConfig(OtaTaskSchedulingConfig var1);

        default public Builder otaSchedulingConfig(Consumer<OtaTaskSchedulingConfig.Builder> otaSchedulingConfig) {
            return this.otaSchedulingConfig((OtaTaskSchedulingConfig)((OtaTaskSchedulingConfig.Builder)OtaTaskSchedulingConfig.builder().applyMutation(otaSchedulingConfig)).build());
        }

        public Builder otaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig var1);

        default public Builder otaTaskExecutionRetryConfig(Consumer<OtaTaskExecutionRetryConfig.Builder> otaTaskExecutionRetryConfig) {
            return this.otaTaskExecutionRetryConfig((OtaTaskExecutionRetryConfig)((OtaTaskExecutionRetryConfig.Builder)OtaTaskExecutionRetryConfig.builder().applyMutation(otaTaskExecutionRetryConfig)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

