/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SchemaVersionType;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SchemaVersionVisibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSchemaVersionResponse
extends IotManagedIntegrationsResponse
implements ToCopyableBuilder<Builder, GetSchemaVersionResponse> {
    private static final SdkField<String> SCHEMA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaId").getter(GetSchemaVersionResponse.getter(GetSchemaVersionResponse::schemaId)).setter(GetSchemaVersionResponse.setter(Builder::schemaId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(GetSchemaVersionResponse.getter(GetSchemaVersionResponse::typeAsString)).setter(GetSchemaVersionResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetSchemaVersionResponse.getter(GetSchemaVersionResponse::description)).setter(GetSchemaVersionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(GetSchemaVersionResponse.getter(GetSchemaVersionResponse::namespace)).setter(GetSchemaVersionResponse.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SemanticVersion").getter(GetSchemaVersionResponse.getter(GetSchemaVersionResponse::semanticVersion)).setter(GetSchemaVersionResponse.setter(Builder::semanticVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SemanticVersion").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(GetSchemaVersionResponse.getter(GetSchemaVersionResponse::visibilityAsString)).setter(GetSchemaVersionResponse.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<Document> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("Schema").getter(GetSchemaVersionResponse.getter(GetSchemaVersionResponse::schema)).setter(GetSchemaVersionResponse.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, NAMESPACE_FIELD, SEMANTIC_VERSION_FIELD, VISIBILITY_FIELD, SCHEMA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSchemaVersionResponse.memberNameToFieldInitializer();
    private final String schemaId;
    private final String type;
    private final String description;
    private final String namespace;
    private final String semanticVersion;
    private final String visibility;
    private final Document schema;

    private GetSchemaVersionResponse(BuilderImpl builder) {
        super(builder);
        this.schemaId = builder.schemaId;
        this.type = builder.type;
        this.description = builder.description;
        this.namespace = builder.namespace;
        this.semanticVersion = builder.semanticVersion;
        this.visibility = builder.visibility;
        this.schema = builder.schema;
    }

    public final String schemaId() {
        return this.schemaId;
    }

    public final SchemaVersionType type() {
        return SchemaVersionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String description() {
        return this.description;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String semanticVersion() {
        return this.semanticVersion;
    }

    public final SchemaVersionVisibility visibility() {
        return SchemaVersionVisibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final Document schema() {
        return this.schema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSchemaVersionResponse)) {
            return false;
        }
        GetSchemaVersionResponse other = (GetSchemaVersionResponse)((Object)obj);
        return Objects.equals(this.schemaId(), other.schemaId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.semanticVersion(), other.semanticVersion()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.schema(), other.schema());
    }

    public final String toString() {
        return ToString.builder((String)"GetSchemaVersionResponse").add("SchemaId", (Object)this.schemaId()).add("Type", (Object)this.typeAsString()).add("Description", (Object)this.description()).add("Namespace", (Object)this.namespace()).add("SemanticVersion", (Object)this.semanticVersion()).add("Visibility", (Object)this.visibilityAsString()).add("Schema", (Object)this.schema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaId": {
                return Optional.ofNullable(clazz.cast(this.schemaId()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "SemanticVersion": {
                return Optional.ofNullable(clazz.cast(this.semanticVersion()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SchemaId", SCHEMA_ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("SemanticVersion", SEMANTIC_VERSION_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSchemaVersionResponse, T> g) {
        return obj -> g.apply((GetSchemaVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsResponse.BuilderImpl
    implements Builder {
        private String schemaId;
        private String type;
        private String description;
        private String namespace;
        private String semanticVersion;
        private String visibility;
        private Document schema;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSchemaVersionResponse model) {
            super(model);
            this.schemaId(model.schemaId);
            this.type(model.type);
            this.description(model.description);
            this.namespace(model.namespace);
            this.semanticVersion(model.semanticVersion);
            this.visibility(model.visibility);
            this.schema(model.schema);
        }

        public final String getSchemaId() {
            return this.schemaId;
        }

        public final void setSchemaId(String schemaId) {
            this.schemaId = schemaId;
        }

        @Override
        public final Builder schemaId(String schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SchemaVersionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getSemanticVersion() {
            return this.semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(SchemaVersionVisibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final Document getSchema() {
            return this.schema;
        }

        public final void setSchema(Document schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(Document schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public GetSchemaVersionResponse build() {
            return new GetSchemaVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotManagedIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSchemaVersionResponse> {
        public Builder schemaId(String var1);

        public Builder type(String var1);

        public Builder type(SchemaVersionType var1);

        public Builder description(String var1);

        public Builder namespace(String var1);

        public Builder semanticVersion(String var1);

        public Builder visibility(String var1);

        public Builder visibility(SchemaVersionVisibility var1);

        public Builder schema(Document var1);
    }
}

