/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsAsyncClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ManagedThingSummary;

public class ListManagedThingsPublisher
implements SdkPublisher<ListManagedThingsResponse> {
    private final IotManagedIntegrationsAsyncClient client;
    private final ListManagedThingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListManagedThingsPublisher(IotManagedIntegrationsAsyncClient client, ListManagedThingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListManagedThingsPublisher(IotManagedIntegrationsAsyncClient client, ListManagedThingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListManagedThingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListManagedThingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ManagedThingSummary> items() {
        Function<ListManagedThingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListManagedThingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListManagedThingsResponseFetcher
    implements AsyncPageFetcher<ListManagedThingsResponse> {
        private ListManagedThingsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedThingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListManagedThingsResponse> nextPage(ListManagedThingsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedThingsPublisher.this.client.listManagedThings(ListManagedThingsPublisher.this.firstRequest);
            }
            return ListManagedThingsPublisher.this.client.listManagedThings((ListManagedThingsRequest)((Object)ListManagedThingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

