/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ConnectorDestinationListDefinitionCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ConnectorDestinationSummary;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConnectorDestinationsResponse
extends IotManagedIntegrationsResponse
implements ToCopyableBuilder<Builder, ListConnectorDestinationsResponse> {
    private static final SdkField<List<ConnectorDestinationSummary>> CONNECTOR_DESTINATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectorDestinationList").getter(ListConnectorDestinationsResponse.getter(ListConnectorDestinationsResponse::connectorDestinationList)).setter(ListConnectorDestinationsResponse.setter(Builder::connectorDestinationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDestinationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectorDestinationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConnectorDestinationsResponse.getter(ListConnectorDestinationsResponse::nextToken)).setter(ListConnectorDestinationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_DESTINATION_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConnectorDestinationsResponse.memberNameToFieldInitializer();
    private final List<ConnectorDestinationSummary> connectorDestinationList;
    private final String nextToken;

    private ListConnectorDestinationsResponse(BuilderImpl builder) {
        super(builder);
        this.connectorDestinationList = builder.connectorDestinationList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConnectorDestinationList() {
        return this.connectorDestinationList != null && !(this.connectorDestinationList instanceof SdkAutoConstructList);
    }

    public final List<ConnectorDestinationSummary> connectorDestinationList() {
        return this.connectorDestinationList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectorDestinationList() ? this.connectorDestinationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectorDestinationsResponse)) {
            return false;
        }
        ListConnectorDestinationsResponse other = (ListConnectorDestinationsResponse)((Object)obj);
        return this.hasConnectorDestinationList() == other.hasConnectorDestinationList() && Objects.equals(this.connectorDestinationList(), other.connectorDestinationList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConnectorDestinationsResponse").add("ConnectorDestinationList", this.hasConnectorDestinationList() ? this.connectorDestinationList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectorDestinationList": {
                return Optional.ofNullable(clazz.cast(this.connectorDestinationList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectorDestinationList", CONNECTOR_DESTINATION_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConnectorDestinationsResponse, T> g) {
        return obj -> g.apply((ListConnectorDestinationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsResponse.BuilderImpl
    implements Builder {
        private List<ConnectorDestinationSummary> connectorDestinationList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectorDestinationsResponse model) {
            super(model);
            this.connectorDestinationList(model.connectorDestinationList);
            this.nextToken(model.nextToken);
        }

        public final List<ConnectorDestinationSummary.Builder> getConnectorDestinationList() {
            List<ConnectorDestinationSummary.Builder> result = ConnectorDestinationListDefinitionCopier.copyToBuilder(this.connectorDestinationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectorDestinationList(Collection<ConnectorDestinationSummary.BuilderImpl> connectorDestinationList) {
            this.connectorDestinationList = ConnectorDestinationListDefinitionCopier.copyFromBuilder(connectorDestinationList);
        }

        @Override
        public final Builder connectorDestinationList(Collection<ConnectorDestinationSummary> connectorDestinationList) {
            this.connectorDestinationList = ConnectorDestinationListDefinitionCopier.copy(connectorDestinationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorDestinationList(ConnectorDestinationSummary ... connectorDestinationList) {
            this.connectorDestinationList(Arrays.asList(connectorDestinationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorDestinationList(Consumer<ConnectorDestinationSummary.Builder> ... connectorDestinationList) {
            this.connectorDestinationList(Stream.of(connectorDestinationList).map(c -> (ConnectorDestinationSummary)((ConnectorDestinationSummary.Builder)ConnectorDestinationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConnectorDestinationsResponse build() {
            return new ListConnectorDestinationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConnectorDestinationsResponse> {
        public Builder connectorDestinationList(Collection<ConnectorDestinationSummary> var1);

        public Builder connectorDestinationList(ConnectorDestinationSummary ... var1);

        public Builder connectorDestinationList(Consumer<ConnectorDestinationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

