/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskListDefinitionCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOtaTasksResponse
extends IotManagedIntegrationsResponse
implements ToCopyableBuilder<Builder, ListOtaTasksResponse> {
    private static final SdkField<List<OtaTaskSummary>> TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tasks").getter(ListOtaTasksResponse.getter(ListOtaTasksResponse::tasks)).setter(ListOtaTasksResponse.setter(Builder::tasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OtaTaskSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOtaTasksResponse.getter(ListOtaTasksResponse::nextToken)).setter(ListOtaTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASKS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListOtaTasksResponse.memberNameToFieldInitializer();
    private final List<OtaTaskSummary> tasks;
    private final String nextToken;

    private ListOtaTasksResponse(BuilderImpl builder) {
        super(builder);
        this.tasks = builder.tasks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTasks() {
        return this.tasks != null && !(this.tasks instanceof SdkAutoConstructList);
    }

    public final List<OtaTaskSummary> tasks() {
        return this.tasks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTasks() ? this.tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOtaTasksResponse)) {
            return false;
        }
        ListOtaTasksResponse other = (ListOtaTasksResponse)((Object)obj);
        return this.hasTasks() == other.hasTasks() && Objects.equals(this.tasks(), other.tasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOtaTasksResponse").add("Tasks", this.hasTasks() ? this.tasks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tasks": {
                return Optional.ofNullable(clazz.cast(this.tasks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Tasks", TASKS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOtaTasksResponse, T> g) {
        return obj -> g.apply((ListOtaTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsResponse.BuilderImpl
    implements Builder {
        private List<OtaTaskSummary> tasks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOtaTasksResponse model) {
            super(model);
            this.tasks(model.tasks);
            this.nextToken(model.nextToken);
        }

        public final List<OtaTaskSummary.Builder> getTasks() {
            List<OtaTaskSummary.Builder> result = OtaTaskListDefinitionCopier.copyToBuilder(this.tasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTasks(Collection<OtaTaskSummary.BuilderImpl> tasks) {
            this.tasks = OtaTaskListDefinitionCopier.copyFromBuilder(tasks);
        }

        @Override
        public final Builder tasks(Collection<OtaTaskSummary> tasks) {
            this.tasks = OtaTaskListDefinitionCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(OtaTaskSummary ... tasks) {
            this.tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<OtaTaskSummary.Builder> ... tasks) {
            this.tasks(Stream.of(tasks).map(c -> (OtaTaskSummary)((OtaTaskSummary.Builder)OtaTaskSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOtaTasksResponse build() {
            return new ListOtaTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOtaTasksResponse> {
        public Builder tasks(Collection<OtaTaskSummary> var1);

        public Builder tasks(OtaTaskSummary ... var1);

        public Builder tasks(Consumer<OtaTaskSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

