/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCommandsCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MatterEventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MatterCluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MatterCluster> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(MatterCluster.getter(MatterCluster::id)).setter(MatterCluster.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Document> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("attributes").getter(MatterCluster.getter(MatterCluster::attributes)).setter(MatterCluster.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()}).build();
    private static final SdkField<Map<String, Document>> COMMANDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("commands").getter(MatterCluster.getter(MatterCluster::commands)).setter(MatterCluster.setter(Builder::commands)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commands").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Document>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("events").getter(MatterCluster.getter(MatterCluster::events)).setter(MatterCluster.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ATTRIBUTES_FIELD, COMMANDS_FIELD, EVENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MatterCluster.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Document attributes;
    private final Map<String, Document> commands;
    private final Map<String, Document> events;

    private MatterCluster(BuilderImpl builder) {
        this.id = builder.id;
        this.attributes = builder.attributes;
        this.commands = builder.commands;
        this.events = builder.events;
    }

    public final String id() {
        return this.id;
    }

    public final Document attributes() {
        return this.attributes;
    }

    public final boolean hasCommands() {
        return this.commands != null && !(this.commands instanceof SdkAutoConstructMap);
    }

    public final Map<String, Document> commands() {
        return this.commands;
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructMap);
    }

    public final Map<String, Document> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommands() ? this.commands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatterCluster)) {
            return false;
        }
        MatterCluster other = (MatterCluster)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.attributes(), other.attributes()) && this.hasCommands() == other.hasCommands() && Objects.equals(this.commands(), other.commands()) && this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events());
    }

    public final String toString() {
        return ToString.builder((String)"MatterCluster").add("Id", (Object)this.id()).add("Attributes", (Object)(this.attributes() == null ? null : "*** Sensitive Data Redacted ***")).add("Commands", (Object)(this.commands() == null ? null : "*** Sensitive Data Redacted ***")).add("Events", (Object)(this.events() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "commands": {
                return Optional.ofNullable(clazz.cast(this.commands()));
            }
            case "events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("commands", COMMANDS_FIELD);
        map.put("events", EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatterCluster, T> g) {
        return obj -> g.apply((MatterCluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Document attributes;
        private Map<String, Document> commands = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Document> events = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MatterCluster model) {
            this.id(model.id);
            this.attributes(model.attributes);
            this.commands(model.commands);
            this.events(model.events);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Document getAttributes() {
            return this.attributes;
        }

        public final void setAttributes(Document attributes) {
            this.attributes = attributes;
        }

        @Override
        public final Builder attributes(Document attributes) {
            this.attributes = attributes;
            return this;
        }

        public final Map<String, Document> getCommands() {
            if (this.commands instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.commands;
        }

        public final void setCommands(Map<String, Document> commands) {
            this.commands = MatterCommandsCopier.copy(commands);
        }

        @Override
        public final Builder commands(Map<String, Document> commands) {
            this.commands = MatterCommandsCopier.copy(commands);
            return this;
        }

        public final Map<String, Document> getEvents() {
            if (this.events instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.events;
        }

        public final void setEvents(Map<String, Document> events) {
            this.events = MatterEventsCopier.copy(events);
        }

        @Override
        public final Builder events(Map<String, Document> events) {
            this.events = MatterEventsCopier.copy(events);
            return this;
        }

        public MatterCluster build() {
            return new MatterCluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MatterCluster> {
        public Builder id(String var1);

        public Builder attributes(Document var1);

        public Builder commands(Map<String, Document> var1);

        public Builder events(Map<String, Document> var1);
    }
}

