/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DisconnectReasonValue;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetManagedThingConnectivityDataResponse
extends IotManagedIntegrationsResponse
implements ToCopyableBuilder<Builder, GetManagedThingConnectivityDataResponse> {
    private static final SdkField<String> MANAGED_THING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedThingId").getter(GetManagedThingConnectivityDataResponse.getter(GetManagedThingConnectivityDataResponse::managedThingId)).setter(GetManagedThingConnectivityDataResponse.setter(Builder::managedThingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedThingId").build()}).build();
    private static final SdkField<Boolean> CONNECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Connected").getter(GetManagedThingConnectivityDataResponse.getter(GetManagedThingConnectivityDataResponse::connected)).setter(GetManagedThingConnectivityDataResponse.setter(Builder::connected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connected").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(GetManagedThingConnectivityDataResponse.getter(GetManagedThingConnectivityDataResponse::timestamp)).setter(GetManagedThingConnectivityDataResponse.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<String> DISCONNECT_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisconnectReason").getter(GetManagedThingConnectivityDataResponse.getter(GetManagedThingConnectivityDataResponse::disconnectReasonAsString)).setter(GetManagedThingConnectivityDataResponse.setter(Builder::disconnectReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_THING_ID_FIELD, CONNECTED_FIELD, TIMESTAMP_FIELD, DISCONNECT_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetManagedThingConnectivityDataResponse.memberNameToFieldInitializer();
    private final String managedThingId;
    private final Boolean connected;
    private final Instant timestamp;
    private final String disconnectReason;

    private GetManagedThingConnectivityDataResponse(BuilderImpl builder) {
        super(builder);
        this.managedThingId = builder.managedThingId;
        this.connected = builder.connected;
        this.timestamp = builder.timestamp;
        this.disconnectReason = builder.disconnectReason;
    }

    public final String managedThingId() {
        return this.managedThingId;
    }

    public final Boolean connected() {
        return this.connected;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final DisconnectReasonValue disconnectReason() {
        return DisconnectReasonValue.fromValue(this.disconnectReason);
    }

    public final String disconnectReasonAsString() {
        return this.disconnectReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.managedThingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connected());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.disconnectReasonAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetManagedThingConnectivityDataResponse)) {
            return false;
        }
        GetManagedThingConnectivityDataResponse other = (GetManagedThingConnectivityDataResponse)((Object)obj);
        return Objects.equals(this.managedThingId(), other.managedThingId()) && Objects.equals(this.connected(), other.connected()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.disconnectReasonAsString(), other.disconnectReasonAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetManagedThingConnectivityDataResponse").add("ManagedThingId", (Object)this.managedThingId()).add("Connected", (Object)this.connected()).add("Timestamp", (Object)this.timestamp()).add("DisconnectReason", (Object)this.disconnectReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManagedThingId": {
                return Optional.ofNullable(clazz.cast(this.managedThingId()));
            }
            case "Connected": {
                return Optional.ofNullable(clazz.cast(this.connected()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "DisconnectReason": {
                return Optional.ofNullable(clazz.cast(this.disconnectReasonAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ManagedThingId", MANAGED_THING_ID_FIELD);
        map.put("Connected", CONNECTED_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("DisconnectReason", DISCONNECT_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetManagedThingConnectivityDataResponse, T> g) {
        return obj -> g.apply((GetManagedThingConnectivityDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsResponse.BuilderImpl
    implements Builder {
        private String managedThingId;
        private Boolean connected;
        private Instant timestamp;
        private String disconnectReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetManagedThingConnectivityDataResponse model) {
            super(model);
            this.managedThingId(model.managedThingId);
            this.connected(model.connected);
            this.timestamp(model.timestamp);
            this.disconnectReason(model.disconnectReason);
        }

        public final String getManagedThingId() {
            return this.managedThingId;
        }

        public final void setManagedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
        }

        @Override
        public final Builder managedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
            return this;
        }

        public final Boolean getConnected() {
            return this.connected;
        }

        public final void setConnected(Boolean connected) {
            this.connected = connected;
        }

        @Override
        public final Builder connected(Boolean connected) {
            this.connected = connected;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getDisconnectReason() {
            return this.disconnectReason;
        }

        public final void setDisconnectReason(String disconnectReason) {
            this.disconnectReason = disconnectReason;
        }

        @Override
        public final Builder disconnectReason(String disconnectReason) {
            this.disconnectReason = disconnectReason;
            return this;
        }

        @Override
        public final Builder disconnectReason(DisconnectReasonValue disconnectReason) {
            this.disconnectReason(disconnectReason == null ? null : disconnectReason.toString());
            return this;
        }

        @Override
        public GetManagedThingConnectivityDataResponse build() {
            return new GetManagedThingConnectivityDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetManagedThingConnectivityDataResponse> {
        public Builder managedThingId(String var1);

        public Builder connected(Boolean var1);

        public Builder timestamp(Instant var1);

        public Builder disconnectReason(String var1);

        public Builder disconnectReason(DisconnectReasonValue var1);
    }
}

