/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsAsyncClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.AccountAssociationItem;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsResponse;

public class ListAccountAssociationsPublisher
implements SdkPublisher<ListAccountAssociationsResponse> {
    private final IotManagedIntegrationsAsyncClient client;
    private final ListAccountAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccountAssociationsPublisher(IotManagedIntegrationsAsyncClient client, ListAccountAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccountAssociationsPublisher(IotManagedIntegrationsAsyncClient client, ListAccountAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccountAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccountAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccountAssociationItem> items() {
        Function<ListAccountAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccountAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccountAssociationsResponseFetcher
    implements AsyncPageFetcher<ListAccountAssociationsResponse> {
        private ListAccountAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccountAssociationsResponse> nextPage(ListAccountAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListAccountAssociationsPublisher.this.client.listAccountAssociations(ListAccountAssociationsPublisher.this.firstRequest);
            }
            return ListAccountAssociationsPublisher.this.client.listAccountAssociations((ListAccountAssociationsRequest)((Object)ListAccountAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

