/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsecuretunneling.model.ClientMode;
import software.amazon.awssdk.services.iotsecuretunneling.model.DestinationConfig;
import software.amazon.awssdk.services.iotsecuretunneling.model.IoTSecureTunnelingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RotateTunnelAccessTokenRequest
extends IoTSecureTunnelingRequest
implements ToCopyableBuilder<Builder, RotateTunnelAccessTokenRequest> {
    private static final SdkField<String> TUNNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tunnelId").getter(RotateTunnelAccessTokenRequest.getter(RotateTunnelAccessTokenRequest::tunnelId)).setter(RotateTunnelAccessTokenRequest.setter(Builder::tunnelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelId").build()}).build();
    private static final SdkField<String> CLIENT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientMode").getter(RotateTunnelAccessTokenRequest.getter(RotateTunnelAccessTokenRequest::clientModeAsString)).setter(RotateTunnelAccessTokenRequest.setter(Builder::clientMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientMode").build()}).build();
    private static final SdkField<DestinationConfig> DESTINATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationConfig").getter(RotateTunnelAccessTokenRequest.getter(RotateTunnelAccessTokenRequest::destinationConfig)).setter(RotateTunnelAccessTokenRequest.setter(Builder::destinationConfig)).constructor(DestinationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TUNNEL_ID_FIELD, CLIENT_MODE_FIELD, DESTINATION_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RotateTunnelAccessTokenRequest.memberNameToFieldInitializer();
    private final String tunnelId;
    private final String clientMode;
    private final DestinationConfig destinationConfig;

    private RotateTunnelAccessTokenRequest(BuilderImpl builder) {
        super(builder);
        this.tunnelId = builder.tunnelId;
        this.clientMode = builder.clientMode;
        this.destinationConfig = builder.destinationConfig;
    }

    public final String tunnelId() {
        return this.tunnelId;
    }

    public final ClientMode clientMode() {
        return ClientMode.fromValue(this.clientMode);
    }

    public final String clientModeAsString() {
        return this.clientMode;
    }

    public final DestinationConfig destinationConfig() {
        return this.destinationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotateTunnelAccessTokenRequest)) {
            return false;
        }
        RotateTunnelAccessTokenRequest other = (RotateTunnelAccessTokenRequest)((Object)obj);
        return Objects.equals(this.tunnelId(), other.tunnelId()) && Objects.equals(this.clientModeAsString(), other.clientModeAsString()) && Objects.equals(this.destinationConfig(), other.destinationConfig());
    }

    public final String toString() {
        return ToString.builder((String)"RotateTunnelAccessTokenRequest").add("TunnelId", (Object)this.tunnelId()).add("ClientMode", (Object)this.clientModeAsString()).add("DestinationConfig", (Object)this.destinationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tunnelId": {
                return Optional.ofNullable(clazz.cast(this.tunnelId()));
            }
            case "clientMode": {
                return Optional.ofNullable(clazz.cast(this.clientModeAsString()));
            }
            case "destinationConfig": {
                return Optional.ofNullable(clazz.cast(this.destinationConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tunnelId", TUNNEL_ID_FIELD);
        map.put("clientMode", CLIENT_MODE_FIELD);
        map.put("destinationConfig", DESTINATION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RotateTunnelAccessTokenRequest, T> g) {
        return obj -> g.apply((RotateTunnelAccessTokenRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSecureTunnelingRequest.BuilderImpl
    implements Builder {
        private String tunnelId;
        private String clientMode;
        private DestinationConfig destinationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RotateTunnelAccessTokenRequest model) {
            super(model);
            this.tunnelId(model.tunnelId);
            this.clientMode(model.clientMode);
            this.destinationConfig(model.destinationConfig);
        }

        public final String getTunnelId() {
            return this.tunnelId;
        }

        public final void setTunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
        }

        @Override
        public final Builder tunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
            return this;
        }

        public final String getClientMode() {
            return this.clientMode;
        }

        public final void setClientMode(String clientMode) {
            this.clientMode = clientMode;
        }

        @Override
        public final Builder clientMode(String clientMode) {
            this.clientMode = clientMode;
            return this;
        }

        @Override
        public final Builder clientMode(ClientMode clientMode) {
            this.clientMode(clientMode == null ? null : clientMode.toString());
            return this;
        }

        public final DestinationConfig.Builder getDestinationConfig() {
            return this.destinationConfig != null ? this.destinationConfig.toBuilder() : null;
        }

        public final void setDestinationConfig(DestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        @Override
        public final Builder destinationConfig(DestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RotateTunnelAccessTokenRequest build() {
            return new RotateTunnelAccessTokenRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSecureTunnelingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RotateTunnelAccessTokenRequest> {
        public Builder tunnelId(String var1);

        public Builder clientMode(String var1);

        public Builder clientMode(ClientMode var1);

        public Builder destinationConfig(DestinationConfig var1);

        default public Builder destinationConfig(Consumer<DestinationConfig.Builder> destinationConfig) {
            return this.destinationConfig((DestinationConfig)((DestinationConfig.Builder)DestinationConfig.builder().applyMutation(destinationConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

