/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.AssetRelationshipSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsResponse;

public class ListAssetRelationshipsPublisher
implements SdkPublisher<ListAssetRelationshipsResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final ListAssetRelationshipsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssetRelationshipsPublisher(IoTSiteWiseAsyncClient client, ListAssetRelationshipsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssetRelationshipsPublisher(IoTSiteWiseAsyncClient client, ListAssetRelationshipsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssetRelationshipsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssetRelationshipsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssetRelationshipSummary> assetRelationshipSummaries() {
        Function<ListAssetRelationshipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetRelationshipSummaries() != null) {
                return response.assetRelationshipSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssetRelationshipsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssetRelationshipsResponseFetcher
    implements AsyncPageFetcher<ListAssetRelationshipsResponse> {
        private ListAssetRelationshipsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetRelationshipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssetRelationshipsResponse> nextPage(ListAssetRelationshipsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetRelationshipsPublisher.this.client.listAssetRelationships(ListAssetRelationshipsPublisher.this.firstRequest);
            }
            return ListAssetRelationshipsPublisher.this.client.listAssetRelationships((ListAssetRelationshipsRequest)((Object)ListAssetRelationshipsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

