/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelExecutionSummaryCopier;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.services.iotsitewise.model.ResolveTo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeComputationModelExecutionSummaryResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeComputationModelExecutionSummaryResponse> {
    private static final SdkField<String> COMPUTATION_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computationModelId").getter(DescribeComputationModelExecutionSummaryResponse.getter(DescribeComputationModelExecutionSummaryResponse::computationModelId)).setter(DescribeComputationModelExecutionSummaryResponse.setter(Builder::computationModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelId").build()}).build();
    private static final SdkField<ResolveTo> RESOLVE_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resolveTo").getter(DescribeComputationModelExecutionSummaryResponse.getter(DescribeComputationModelExecutionSummaryResponse::resolveTo)).setter(DescribeComputationModelExecutionSummaryResponse.setter(Builder::resolveTo)).constructor(ResolveTo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolveTo").build()}).build();
    private static final SdkField<Map<String, String>> COMPUTATION_MODEL_EXECUTION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("computationModelExecutionSummary").getter(DescribeComputationModelExecutionSummaryResponse.getter(DescribeComputationModelExecutionSummaryResponse::computationModelExecutionSummary)).setter(DescribeComputationModelExecutionSummaryResponse.setter(Builder::computationModelExecutionSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelExecutionSummary").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_MODEL_ID_FIELD, RESOLVE_TO_FIELD, COMPUTATION_MODEL_EXECUTION_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeComputationModelExecutionSummaryResponse.memberNameToFieldInitializer();
    private final String computationModelId;
    private final ResolveTo resolveTo;
    private final Map<String, String> computationModelExecutionSummary;

    private DescribeComputationModelExecutionSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.computationModelId = builder.computationModelId;
        this.resolveTo = builder.resolveTo;
        this.computationModelExecutionSummary = builder.computationModelExecutionSummary;
    }

    public final String computationModelId() {
        return this.computationModelId;
    }

    public final ResolveTo resolveTo() {
        return this.resolveTo;
    }

    public final boolean hasComputationModelExecutionSummary() {
        return this.computationModelExecutionSummary != null && !(this.computationModelExecutionSummary instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> computationModelExecutionSummary() {
        return this.computationModelExecutionSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolveTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputationModelExecutionSummary() ? this.computationModelExecutionSummary() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputationModelExecutionSummaryResponse)) {
            return false;
        }
        DescribeComputationModelExecutionSummaryResponse other = (DescribeComputationModelExecutionSummaryResponse)((Object)obj);
        return Objects.equals(this.computationModelId(), other.computationModelId()) && Objects.equals(this.resolveTo(), other.resolveTo()) && this.hasComputationModelExecutionSummary() == other.hasComputationModelExecutionSummary() && Objects.equals(this.computationModelExecutionSummary(), other.computationModelExecutionSummary());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeComputationModelExecutionSummaryResponse").add("ComputationModelId", (Object)this.computationModelId()).add("ResolveTo", (Object)this.resolveTo()).add("ComputationModelExecutionSummary", this.hasComputationModelExecutionSummary() ? this.computationModelExecutionSummary() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computationModelId": {
                return Optional.ofNullable(clazz.cast(this.computationModelId()));
            }
            case "resolveTo": {
                return Optional.ofNullable(clazz.cast(this.resolveTo()));
            }
            case "computationModelExecutionSummary": {
                return Optional.ofNullable(clazz.cast(this.computationModelExecutionSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("computationModelId", COMPUTATION_MODEL_ID_FIELD);
        map.put("resolveTo", RESOLVE_TO_FIELD);
        map.put("computationModelExecutionSummary", COMPUTATION_MODEL_EXECUTION_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeComputationModelExecutionSummaryResponse, T> g) {
        return obj -> g.apply((DescribeComputationModelExecutionSummaryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String computationModelId;
        private ResolveTo resolveTo;
        private Map<String, String> computationModelExecutionSummary = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputationModelExecutionSummaryResponse model) {
            super(model);
            this.computationModelId(model.computationModelId);
            this.resolveTo(model.resolveTo);
            this.computationModelExecutionSummary(model.computationModelExecutionSummary);
        }

        public final String getComputationModelId() {
            return this.computationModelId;
        }

        public final void setComputationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
        }

        @Override
        public final Builder computationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
            return this;
        }

        public final ResolveTo.Builder getResolveTo() {
            return this.resolveTo != null ? this.resolveTo.toBuilder() : null;
        }

        public final void setResolveTo(ResolveTo.BuilderImpl resolveTo) {
            this.resolveTo = resolveTo != null ? resolveTo.build() : null;
        }

        @Override
        public final Builder resolveTo(ResolveTo resolveTo) {
            this.resolveTo = resolveTo;
            return this;
        }

        public final Map<String, String> getComputationModelExecutionSummary() {
            if (this.computationModelExecutionSummary instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.computationModelExecutionSummary;
        }

        public final void setComputationModelExecutionSummary(Map<String, String> computationModelExecutionSummary) {
            this.computationModelExecutionSummary = ComputationModelExecutionSummaryCopier.copy(computationModelExecutionSummary);
        }

        @Override
        public final Builder computationModelExecutionSummary(Map<String, String> computationModelExecutionSummary) {
            this.computationModelExecutionSummary = ComputationModelExecutionSummaryCopier.copy(computationModelExecutionSummary);
            return this;
        }

        @Override
        public DescribeComputationModelExecutionSummaryResponse build() {
            return new DescribeComputationModelExecutionSummaryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeComputationModelExecutionSummaryResponse> {
        public Builder computationModelId(String var1);

        public Builder resolveTo(ResolveTo var1);

        default public Builder resolveTo(Consumer<ResolveTo.Builder> resolveTo) {
            return this.resolveTo((ResolveTo)((ResolveTo.Builder)ResolveTo.builder().applyMutation(resolveTo)).build());
        }

        public Builder computationModelExecutionSummary(Map<String, String> var1);
    }
}

