/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingUsageSummariesCopier;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingUsageSummary;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListComputationModelDataBindingUsagesResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, ListComputationModelDataBindingUsagesResponse> {
    private static final SdkField<List<ComputationModelDataBindingUsageSummary>> DATA_BINDING_USAGE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataBindingUsageSummaries").getter(ListComputationModelDataBindingUsagesResponse.getter(ListComputationModelDataBindingUsagesResponse::dataBindingUsageSummaries)).setter(ListComputationModelDataBindingUsagesResponse.setter(Builder::dataBindingUsageSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataBindingUsageSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComputationModelDataBindingUsageSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListComputationModelDataBindingUsagesResponse.getter(ListComputationModelDataBindingUsagesResponse::nextToken)).setter(ListComputationModelDataBindingUsagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_BINDING_USAGE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListComputationModelDataBindingUsagesResponse.memberNameToFieldInitializer();
    private final List<ComputationModelDataBindingUsageSummary> dataBindingUsageSummaries;
    private final String nextToken;

    private ListComputationModelDataBindingUsagesResponse(BuilderImpl builder) {
        super(builder);
        this.dataBindingUsageSummaries = builder.dataBindingUsageSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDataBindingUsageSummaries() {
        return this.dataBindingUsageSummaries != null && !(this.dataBindingUsageSummaries instanceof SdkAutoConstructList);
    }

    public final List<ComputationModelDataBindingUsageSummary> dataBindingUsageSummaries() {
        return this.dataBindingUsageSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataBindingUsageSummaries() ? this.dataBindingUsageSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComputationModelDataBindingUsagesResponse)) {
            return false;
        }
        ListComputationModelDataBindingUsagesResponse other = (ListComputationModelDataBindingUsagesResponse)((Object)obj);
        return this.hasDataBindingUsageSummaries() == other.hasDataBindingUsageSummaries() && Objects.equals(this.dataBindingUsageSummaries(), other.dataBindingUsageSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListComputationModelDataBindingUsagesResponse").add("DataBindingUsageSummaries", this.hasDataBindingUsageSummaries() ? this.dataBindingUsageSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataBindingUsageSummaries": {
                return Optional.ofNullable(clazz.cast(this.dataBindingUsageSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataBindingUsageSummaries", DATA_BINDING_USAGE_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListComputationModelDataBindingUsagesResponse, T> g) {
        return obj -> g.apply((ListComputationModelDataBindingUsagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<ComputationModelDataBindingUsageSummary> dataBindingUsageSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComputationModelDataBindingUsagesResponse model) {
            super(model);
            this.dataBindingUsageSummaries(model.dataBindingUsageSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ComputationModelDataBindingUsageSummary.Builder> getDataBindingUsageSummaries() {
            List<ComputationModelDataBindingUsageSummary.Builder> result = ComputationModelDataBindingUsageSummariesCopier.copyToBuilder(this.dataBindingUsageSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataBindingUsageSummaries(Collection<ComputationModelDataBindingUsageSummary.BuilderImpl> dataBindingUsageSummaries) {
            this.dataBindingUsageSummaries = ComputationModelDataBindingUsageSummariesCopier.copyFromBuilder(dataBindingUsageSummaries);
        }

        @Override
        public final Builder dataBindingUsageSummaries(Collection<ComputationModelDataBindingUsageSummary> dataBindingUsageSummaries) {
            this.dataBindingUsageSummaries = ComputationModelDataBindingUsageSummariesCopier.copy(dataBindingUsageSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataBindingUsageSummaries(ComputationModelDataBindingUsageSummary ... dataBindingUsageSummaries) {
            this.dataBindingUsageSummaries(Arrays.asList(dataBindingUsageSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataBindingUsageSummaries(Consumer<ComputationModelDataBindingUsageSummary.Builder> ... dataBindingUsageSummaries) {
            this.dataBindingUsageSummaries(Stream.of(dataBindingUsageSummaries).map(c -> (ComputationModelDataBindingUsageSummary)((ComputationModelDataBindingUsageSummary.Builder)ComputationModelDataBindingUsageSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListComputationModelDataBindingUsagesResponse build() {
            return new ListComputationModelDataBindingUsagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListComputationModelDataBindingUsagesResponse> {
        public Builder dataBindingUsageSummaries(Collection<ComputationModelDataBindingUsageSummary> var1);

        public Builder dataBindingUsageSummaries(ComputationModelDataBindingUsageSummary ... var1);

        public Builder dataBindingUsageSummaries(Consumer<ComputationModelDataBindingUsageSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

