/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.AssociatedAssetsSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsResponse;

public class ListAssociatedAssetsPublisher
implements SdkPublisher<ListAssociatedAssetsResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final ListAssociatedAssetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssociatedAssetsPublisher(IoTSiteWiseAsyncClient client, ListAssociatedAssetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssociatedAssetsPublisher(IoTSiteWiseAsyncClient client, ListAssociatedAssetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssociatedAssetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssociatedAssetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssociatedAssetsSummary> assetSummaries() {
        Function<ListAssociatedAssetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetSummaries() != null) {
                return response.assetSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssociatedAssetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssociatedAssetsResponseFetcher
    implements AsyncPageFetcher<ListAssociatedAssetsResponse> {
        private ListAssociatedAssetsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociatedAssetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssociatedAssetsResponse> nextPage(ListAssociatedAssetsResponse previousPage) {
            if (previousPage == null) {
                return ListAssociatedAssetsPublisher.this.client.listAssociatedAssets(ListAssociatedAssetsPublisher.this.firstRequest);
            }
            return ListAssociatedAssetsPublisher.this.client.listAssociatedAssets((ListAssociatedAssetsRequest)((Object)ListAssociatedAssetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

