/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelResolveToResourceSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListComputationModelResolveToResourcesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListComputationModelResolveToResourcesResponse;

public class ListComputationModelResolveToResourcesPublisher
implements SdkPublisher<ListComputationModelResolveToResourcesResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final ListComputationModelResolveToResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListComputationModelResolveToResourcesPublisher(IoTSiteWiseAsyncClient client, ListComputationModelResolveToResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListComputationModelResolveToResourcesPublisher(IoTSiteWiseAsyncClient client, ListComputationModelResolveToResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListComputationModelResolveToResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListComputationModelResolveToResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ComputationModelResolveToResourceSummary> computationModelResolveToResourceSummaries() {
        Function<ListComputationModelResolveToResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.computationModelResolveToResourceSummaries() != null) {
                return response.computationModelResolveToResourceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListComputationModelResolveToResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListComputationModelResolveToResourcesResponseFetcher
    implements AsyncPageFetcher<ListComputationModelResolveToResourcesResponse> {
        private ListComputationModelResolveToResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListComputationModelResolveToResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListComputationModelResolveToResourcesResponse> nextPage(ListComputationModelResolveToResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListComputationModelResolveToResourcesPublisher.this.client.listComputationModelResolveToResources(ListComputationModelResolveToResourcesPublisher.this.firstRequest);
            }
            return ListComputationModelResolveToResourcesPublisher.this.client.listComputationModelResolveToResources((ListComputationModelResolveToResourcesRequest)((Object)ListComputationModelResolveToResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

