/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that specifies the data type of a property.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataType implements SdkPojo, Serializable, ToCopyableBuilder<DataType.Builder, DataType> {
    private static final SdkField<List<DataValue>> ALLOWED_VALUES_FIELD = SdkField
            .<List<DataValue>> builder(MarshallingType.LIST)
            .memberName("allowedValues")
            .getter(getter(DataType::allowedValues))
            .setter(setter(Builder::allowedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataType> NESTED_TYPE_FIELD = SdkField.<DataType> builder(MarshallingType.SDK_POJO)
            .memberName("nestedType").getter(getter(DataType::nestedType)).setter(setter(Builder::nestedType))
            .constructor(DataType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nestedType").build()).build();

    private static final SdkField<Relationship> RELATIONSHIP_FIELD = SdkField.<Relationship> builder(MarshallingType.SDK_POJO)
            .memberName("relationship").getter(getter(DataType::relationship)).setter(setter(Builder::relationship))
            .constructor(Relationship::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationship").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DataType::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> UNIT_OF_MEASURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("unitOfMeasure").getter(getter(DataType::unitOfMeasure)).setter(setter(Builder::unitOfMeasure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unitOfMeasure").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_VALUES_FIELD,
            NESTED_TYPE_FIELD, RELATIONSHIP_FIELD, TYPE_FIELD, UNIT_OF_MEASURE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DataValue> allowedValues;

    private final DataType nestedType;

    private final Relationship relationship;

    private final String type;

    private final String unitOfMeasure;

    private DataType(BuilderImpl builder) {
        this.allowedValues = builder.allowedValues;
        this.nestedType = builder.nestedType;
        this.relationship = builder.relationship;
        this.type = builder.type;
        this.unitOfMeasure = builder.unitOfMeasure;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedValues() {
        return allowedValues != null && !(allowedValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The allowed values for this data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedValues} method.
     * </p>
     * 
     * @return The allowed values for this data type.
     */
    public final List<DataValue> allowedValues() {
        return allowedValues;
    }

    /**
     * <p>
     * The nested type in the data type.
     * </p>
     * 
     * @return The nested type in the data type.
     */
    public final DataType nestedType() {
        return nestedType;
    }

    /**
     * <p>
     * A relationship that associates a component with another component.
     * </p>
     * 
     * @return A relationship that associates a component with another component.
     */
    public final Relationship relationship() {
        return relationship;
    }

    /**
     * <p>
     * The underlying type of the data type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The underlying type of the data type.
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * The underlying type of the data type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The underlying type of the data type.
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The unit of measure used in this data type.
     * </p>
     * 
     * @return The unit of measure used in this data type.
     */
    public final String unitOfMeasure() {
        return unitOfMeasure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedValues() ? allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nestedType());
        hashCode = 31 * hashCode + Objects.hashCode(relationship());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(unitOfMeasure());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataType)) {
            return false;
        }
        DataType other = (DataType) obj;
        return hasAllowedValues() == other.hasAllowedValues() && Objects.equals(allowedValues(), other.allowedValues())
                && Objects.equals(nestedType(), other.nestedType()) && Objects.equals(relationship(), other.relationship())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(unitOfMeasure(), other.unitOfMeasure());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataType").add("AllowedValues", hasAllowedValues() ? allowedValues() : null)
                .add("NestedType", nestedType()).add("Relationship", relationship()).add("Type", typeAsString())
                .add("UnitOfMeasure", unitOfMeasure()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowedValues":
            return Optional.ofNullable(clazz.cast(allowedValues()));
        case "nestedType":
            return Optional.ofNullable(clazz.cast(nestedType()));
        case "relationship":
            return Optional.ofNullable(clazz.cast(relationship()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "unitOfMeasure":
            return Optional.ofNullable(clazz.cast(unitOfMeasure()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataType, T> g) {
        return obj -> g.apply((DataType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataType> {
        /**
         * <p>
         * The allowed values for this data type.
         * </p>
         * 
         * @param allowedValues
         *        The allowed values for this data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(Collection<DataValue> allowedValues);

        /**
         * <p>
         * The allowed values for this data type.
         * </p>
         * 
         * @param allowedValues
         *        The allowed values for this data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(DataValue... allowedValues);

        /**
         * <p>
         * The allowed values for this data type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataValue>.Builder} avoiding the need to
         * create one manually via {@link List<DataValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataValue>.Builder#build()} is called immediately and its
         * result is passed to {@link #allowedValues(List<DataValue>)}.
         * 
         * @param allowedValues
         *        a consumer that will call methods on {@link List<DataValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allowedValues(List<DataValue>)
         */
        Builder allowedValues(Consumer<DataValue.Builder>... allowedValues);

        /**
         * <p>
         * The nested type in the data type.
         * </p>
         * 
         * @param nestedType
         *        The nested type in the data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nestedType(DataType nestedType);

        /**
         * <p>
         * The nested type in the data type.
         * </p>
         * This is a convenience that creates an instance of the {@link DataType.Builder} avoiding the need to create
         * one manually via {@link DataType#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataType.Builder#build()} is called immediately and its result is
         * passed to {@link #nestedType(DataType)}.
         * 
         * @param nestedType
         *        a consumer that will call methods on {@link DataType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nestedType(DataType)
         */
        default Builder nestedType(Consumer<Builder> nestedType) {
            return nestedType(DataType.builder().applyMutation(nestedType).build());
        }

        /**
         * <p>
         * A relationship that associates a component with another component.
         * </p>
         * 
         * @param relationship
         *        A relationship that associates a component with another component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationship(Relationship relationship);

        /**
         * <p>
         * A relationship that associates a component with another component.
         * </p>
         * This is a convenience that creates an instance of the {@link Relationship.Builder} avoiding the need to
         * create one manually via {@link Relationship#builder()}.
         *
         * When the {@link Consumer} completes, {@link Relationship.Builder#build()} is called immediately and its
         * result is passed to {@link #relationship(Relationship)}.
         * 
         * @param relationship
         *        a consumer that will call methods on {@link Relationship.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relationship(Relationship)
         */
        default Builder relationship(Consumer<Relationship.Builder> relationship) {
            return relationship(Relationship.builder().applyMutation(relationship).build());
        }

        /**
         * <p>
         * The underlying type of the data type.
         * </p>
         * 
         * @param type
         *        The underlying type of the data type.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * The underlying type of the data type.
         * </p>
         * 
         * @param type
         *        The underlying type of the data type.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        /**
         * <p>
         * The unit of measure used in this data type.
         * </p>
         * 
         * @param unitOfMeasure
         *        The unit of measure used in this data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unitOfMeasure(String unitOfMeasure);
    }

    static final class BuilderImpl implements Builder {
        private List<DataValue> allowedValues = DefaultSdkAutoConstructList.getInstance();

        private DataType nestedType;

        private Relationship relationship;

        private String type;

        private String unitOfMeasure;

        private BuilderImpl() {
        }

        private BuilderImpl(DataType model) {
            allowedValues(model.allowedValues);
            nestedType(model.nestedType);
            relationship(model.relationship);
            type(model.type);
            unitOfMeasure(model.unitOfMeasure);
        }

        public final List<DataValue.Builder> getAllowedValues() {
            List<DataValue.Builder> result = DataValueListCopier.copyToBuilder(this.allowedValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowedValues(Collection<DataValue.BuilderImpl> allowedValues) {
            this.allowedValues = DataValueListCopier.copyFromBuilder(allowedValues);
        }

        @Override
        @Transient
        public final Builder allowedValues(Collection<DataValue> allowedValues) {
            this.allowedValues = DataValueListCopier.copy(allowedValues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder allowedValues(DataValue... allowedValues) {
            allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder allowedValues(Consumer<DataValue.Builder>... allowedValues) {
            allowedValues(Stream.of(allowedValues).map(c -> DataValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Builder getNestedType() {
            return nestedType != null ? nestedType.toBuilder() : null;
        }

        public final void setNestedType(BuilderImpl nestedType) {
            this.nestedType = nestedType != null ? nestedType.build() : null;
        }

        @Override
        @Transient
        public final Builder nestedType(DataType nestedType) {
            this.nestedType = nestedType;
            return this;
        }

        public final Relationship.Builder getRelationship() {
            return relationship != null ? relationship.toBuilder() : null;
        }

        public final void setRelationship(Relationship.BuilderImpl relationship) {
            this.relationship = relationship != null ? relationship.build() : null;
        }

        @Override
        @Transient
        public final Builder relationship(Relationship relationship) {
            this.relationship = relationship;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getUnitOfMeasure() {
            return unitOfMeasure;
        }

        public final void setUnitOfMeasure(String unitOfMeasure) {
            this.unitOfMeasure = unitOfMeasure;
        }

        @Override
        @Transient
        public final Builder unitOfMeasure(String unitOfMeasure) {
            this.unitOfMeasure = unitOfMeasure;
            return this;
        }

        @Override
        public DataType build() {
            return new DataType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
