/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that filters items in a list of entities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEntitiesFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListEntitiesFilter.Builder, ListEntitiesFilter> {
    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentTypeId").getter(getter(ListEntitiesFilter::componentTypeId))
            .setter(setter(Builder::componentTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()).build();

    private static final SdkField<String> PARENT_ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentEntityId").getter(getter(ListEntitiesFilter::parentEntityId))
            .setter(setter(Builder::parentEntityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentEntityId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_TYPE_ID_FIELD,
            PARENT_ENTITY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String componentTypeId;

    private final String parentEntityId;

    private ListEntitiesFilter(BuilderImpl builder) {
        this.componentTypeId = builder.componentTypeId;
        this.parentEntityId = builder.parentEntityId;
    }

    /**
     * <p>
     * The ID of the component type in the entities in the list.
     * </p>
     * 
     * @return The ID of the component type in the entities in the list.
     */
    public final String componentTypeId() {
        return componentTypeId;
    }

    /**
     * <p>
     * The parent of the entities in the list.
     * </p>
     * 
     * @return The parent of the entities in the list.
     */
    public final String parentEntityId() {
        return parentEntityId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(parentEntityId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesFilter)) {
            return false;
        }
        ListEntitiesFilter other = (ListEntitiesFilter) obj;
        return Objects.equals(componentTypeId(), other.componentTypeId())
                && Objects.equals(parentEntityId(), other.parentEntityId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEntitiesFilter").add("ComponentTypeId", componentTypeId())
                .add("ParentEntityId", parentEntityId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentTypeId":
            return Optional.ofNullable(clazz.cast(componentTypeId()));
        case "parentEntityId":
            return Optional.ofNullable(clazz.cast(parentEntityId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEntitiesFilter, T> g) {
        return obj -> g.apply((ListEntitiesFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListEntitiesFilter> {
        /**
         * <p>
         * The ID of the component type in the entities in the list.
         * </p>
         * 
         * @param componentTypeId
         *        The ID of the component type in the entities in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTypeId(String componentTypeId);

        /**
         * <p>
         * The parent of the entities in the list.
         * </p>
         * 
         * @param parentEntityId
         *        The parent of the entities in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentEntityId(String parentEntityId);
    }

    static final class BuilderImpl implements Builder {
        private String componentTypeId;

        private String parentEntityId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesFilter model) {
            componentTypeId(model.componentTypeId);
            parentEntityId(model.parentEntityId);
        }

        public final String getComponentTypeId() {
            return componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        @Transient
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final String getParentEntityId() {
            return parentEntityId;
        }

        public final void setParentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
        }

        @Override
        @Transient
        public final Builder parentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
            return this;
        }

        @Override
        public ListEntitiesFilter build() {
            return new ListEntitiesFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
