/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about a property response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<PropertyResponse.Builder, PropertyResponse> {
    private static final SdkField<PropertyDefinitionResponse> DEFINITION_FIELD = SdkField
            .<PropertyDefinitionResponse> builder(MarshallingType.SDK_POJO).memberName("definition")
            .getter(getter(PropertyResponse::definition)).setter(setter(Builder::definition))
            .constructor(PropertyDefinitionResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<DataValue> VALUE_FIELD = SdkField.<DataValue> builder(MarshallingType.SDK_POJO)
            .memberName("value").getter(getter(PropertyResponse::value)).setter(setter(Builder::value))
            .constructor(DataValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DEFINITION_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final PropertyDefinitionResponse definition;

    private final DataValue value;

    private PropertyResponse(BuilderImpl builder) {
        this.definition = builder.definition;
        this.value = builder.value;
    }

    /**
     * <p>
     * An object that specifies information about a property.
     * </p>
     * 
     * @return An object that specifies information about a property.
     */
    public final PropertyDefinitionResponse definition() {
        return definition;
    }

    /**
     * <p>
     * The value of the property.
     * </p>
     * 
     * @return The value of the property.
     */
    public final DataValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyResponse)) {
            return false;
        }
        PropertyResponse other = (PropertyResponse) obj;
        return Objects.equals(definition(), other.definition()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertyResponse").add("Definition", definition()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyResponse, T> g) {
        return obj -> g.apply((PropertyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyResponse> {
        /**
         * <p>
         * An object that specifies information about a property.
         * </p>
         * 
         * @param definition
         *        An object that specifies information about a property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(PropertyDefinitionResponse definition);

        /**
         * <p>
         * An object that specifies information about a property.
         * </p>
         * This is a convenience that creates an instance of the {@link PropertyDefinitionResponse.Builder} avoiding the
         * need to create one manually via {@link PropertyDefinitionResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link PropertyDefinitionResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #definition(PropertyDefinitionResponse)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link PropertyDefinitionResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(PropertyDefinitionResponse)
         */
        default Builder definition(Consumer<PropertyDefinitionResponse.Builder> definition) {
            return definition(PropertyDefinitionResponse.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The value of the property.
         * </p>
         * 
         * @param value
         *        The value of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(DataValue value);

        /**
         * <p>
         * The value of the property.
         * </p>
         * This is a convenience that creates an instance of the {@link DataValue.Builder} avoiding the need to create
         * one manually via {@link DataValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataValue.Builder#build()} is called immediately and its result
         * is passed to {@link #value(DataValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link DataValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(DataValue)
         */
        default Builder value(Consumer<DataValue.Builder> value) {
            return value(DataValue.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PropertyDefinitionResponse definition;

        private DataValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyResponse model) {
            definition(model.definition);
            value(model.value);
        }

        public final PropertyDefinitionResponse.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(PropertyDefinitionResponse.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        @Transient
        public final Builder definition(PropertyDefinitionResponse definition) {
            this.definition = definition;
            return this;
        }

        public final DataValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(DataValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        @Transient
        public final Builder value(DataValue value) {
            this.value = value;
            return this;
        }

        @Override
        public PropertyResponse build() {
            return new PropertyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
