/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about a scene.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SceneSummary implements SdkPojo, Serializable, ToCopyableBuilder<SceneSummary.Builder, SceneSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(SceneSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CONTENT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentLocation").getter(getter(SceneSummary::contentLocation)).setter(setter(Builder::contentLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentLocation").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(SceneSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SceneSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> SCENE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sceneId").getter(getter(SceneSummary::sceneId)).setter(setter(Builder::sceneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneId").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateDateTime").getter(getter(SceneSummary::updateDateTime)).setter(setter(Builder::updateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CONTENT_LOCATION_FIELD, CREATION_DATE_TIME_FIELD, DESCRIPTION_FIELD, SCENE_ID_FIELD, UPDATE_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String contentLocation;

    private final Instant creationDateTime;

    private final String description;

    private final String sceneId;

    private final Instant updateDateTime;

    private SceneSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.contentLocation = builder.contentLocation;
        this.creationDateTime = builder.creationDateTime;
        this.description = builder.description;
        this.sceneId = builder.sceneId;
        this.updateDateTime = builder.updateDateTime;
    }

    /**
     * <p>
     * The ARN of the scene.
     * </p>
     * 
     * @return The ARN of the scene.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The relative path that specifies the location of the content definition file.
     * </p>
     * 
     * @return The relative path that specifies the location of the content definition file.
     */
    public final String contentLocation() {
        return contentLocation;
    }

    /**
     * <p>
     * The date and time when the scene was created.
     * </p>
     * 
     * @return The date and time when the scene was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The scene description.
     * </p>
     * 
     * @return The scene description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the scene.
     * </p>
     * 
     * @return The ID of the scene.
     */
    public final String sceneId() {
        return sceneId;
    }

    /**
     * <p>
     * The date and time when the scene was last updated.
     * </p>
     * 
     * @return The date and time when the scene was last updated.
     */
    public final Instant updateDateTime() {
        return updateDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(contentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sceneId());
        hashCode = 31 * hashCode + Objects.hashCode(updateDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SceneSummary)) {
            return false;
        }
        SceneSummary other = (SceneSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(contentLocation(), other.contentLocation())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(description(), other.description()) && Objects.equals(sceneId(), other.sceneId())
                && Objects.equals(updateDateTime(), other.updateDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SceneSummary").add("Arn", arn()).add("ContentLocation", contentLocation())
                .add("CreationDateTime", creationDateTime()).add("Description", description()).add("SceneId", sceneId())
                .add("UpdateDateTime", updateDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "contentLocation":
            return Optional.ofNullable(clazz.cast(contentLocation()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "sceneId":
            return Optional.ofNullable(clazz.cast(sceneId()));
        case "updateDateTime":
            return Optional.ofNullable(clazz.cast(updateDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SceneSummary, T> g) {
        return obj -> g.apply((SceneSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SceneSummary> {
        /**
         * <p>
         * The ARN of the scene.
         * </p>
         * 
         * @param arn
         *        The ARN of the scene.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The relative path that specifies the location of the content definition file.
         * </p>
         * 
         * @param contentLocation
         *        The relative path that specifies the location of the content definition file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentLocation(String contentLocation);

        /**
         * <p>
         * The date and time when the scene was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time when the scene was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The scene description.
         * </p>
         * 
         * @param description
         *        The scene description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the scene.
         * </p>
         * 
         * @param sceneId
         *        The ID of the scene.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sceneId(String sceneId);

        /**
         * <p>
         * The date and time when the scene was last updated.
         * </p>
         * 
         * @param updateDateTime
         *        The date and time when the scene was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDateTime(Instant updateDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String contentLocation;

        private Instant creationDateTime;

        private String description;

        private String sceneId;

        private Instant updateDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SceneSummary model) {
            arn(model.arn);
            contentLocation(model.contentLocation);
            creationDateTime(model.creationDateTime);
            description(model.description);
            sceneId(model.sceneId);
            updateDateTime(model.updateDateTime);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getContentLocation() {
            return contentLocation;
        }

        public final void setContentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
        }

        @Override
        @Transient
        public final Builder contentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSceneId() {
            return sceneId;
        }

        public final void setSceneId(String sceneId) {
            this.sceneId = sceneId;
        }

        @Override
        @Transient
        public final Builder sceneId(String sceneId) {
            this.sceneId = sceneId;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        @Transient
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        @Override
        public SceneSummary build() {
            return new SceneSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
