/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Type {
    RELATIONSHIP("RELATIONSHIP"),
    STRING("STRING"),
    LONG("LONG"),
    BOOLEAN("BOOLEAN"),
    INTEGER("INTEGER"),
    DOUBLE("DOUBLE"),
    LIST("LIST"),
    MAP("MAP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Type> VALUE_MAP;
    private final String value;

    private Type(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Type fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Type> knownValues() {
        EnumSet<Type> knownValues = EnumSet.allOf(Type.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Type.class, Type::toString);
    }
}

