/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition;
import software.amazon.awssdk.services.ivs.model.RenditionConfigurationRenditionListCopier;
import software.amazon.awssdk.services.ivs.model.RenditionConfigurationRenditionSelection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RenditionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RenditionConfiguration> {
    private static final SdkField<String> RENDITION_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("renditionSelection").getter(RenditionConfiguration.getter(RenditionConfiguration::renditionSelectionAsString)).setter(RenditionConfiguration.setter(Builder::renditionSelection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renditionSelection").build()}).build();
    private static final SdkField<List<String>> RENDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("renditions").getter(RenditionConfiguration.getter(RenditionConfiguration::renditionsAsStrings)).setter(RenditionConfiguration.setter(Builder::renditionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENDITION_SELECTION_FIELD, RENDITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RenditionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String renditionSelection;
    private final List<String> renditions;

    private RenditionConfiguration(BuilderImpl builder) {
        this.renditionSelection = builder.renditionSelection;
        this.renditions = builder.renditions;
    }

    public final RenditionConfigurationRenditionSelection renditionSelection() {
        return RenditionConfigurationRenditionSelection.fromValue(this.renditionSelection);
    }

    public final String renditionSelectionAsString() {
        return this.renditionSelection;
    }

    public final List<RenditionConfigurationRendition> renditions() {
        return RenditionConfigurationRenditionListCopier.copyStringToEnum(this.renditions);
    }

    public final boolean hasRenditions() {
        return this.renditions != null && !(this.renditions instanceof SdkAutoConstructList);
    }

    public final List<String> renditionsAsStrings() {
        return this.renditions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.renditionSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRenditions() ? this.renditionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenditionConfiguration)) {
            return false;
        }
        RenditionConfiguration other = (RenditionConfiguration)obj;
        return Objects.equals(this.renditionSelectionAsString(), other.renditionSelectionAsString()) && this.hasRenditions() == other.hasRenditions() && Objects.equals(this.renditionsAsStrings(), other.renditionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"RenditionConfiguration").add("RenditionSelection", (Object)this.renditionSelectionAsString()).add("Renditions", this.hasRenditions() ? this.renditionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "renditionSelection": {
                return Optional.ofNullable(clazz.cast(this.renditionSelectionAsString()));
            }
            case "renditions": {
                return Optional.ofNullable(clazz.cast(this.renditionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("renditionSelection", RENDITION_SELECTION_FIELD);
        map.put("renditions", RENDITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RenditionConfiguration, T> g) {
        return obj -> g.apply((RenditionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String renditionSelection;
        private List<String> renditions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RenditionConfiguration model) {
            this.renditionSelection(model.renditionSelection);
            this.renditionsWithStrings(model.renditions);
        }

        public final String getRenditionSelection() {
            return this.renditionSelection;
        }

        public final void setRenditionSelection(String renditionSelection) {
            this.renditionSelection = renditionSelection;
        }

        @Override
        public final Builder renditionSelection(String renditionSelection) {
            this.renditionSelection = renditionSelection;
            return this;
        }

        @Override
        public final Builder renditionSelection(RenditionConfigurationRenditionSelection renditionSelection) {
            this.renditionSelection(renditionSelection == null ? null : renditionSelection.toString());
            return this;
        }

        public final Collection<String> getRenditions() {
            if (this.renditions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.renditions;
        }

        public final void setRenditions(Collection<String> renditions) {
            this.renditions = RenditionConfigurationRenditionListCopier.copy(renditions);
        }

        @Override
        public final Builder renditionsWithStrings(Collection<String> renditions) {
            this.renditions = RenditionConfigurationRenditionListCopier.copy(renditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder renditionsWithStrings(String ... renditions) {
            this.renditionsWithStrings(Arrays.asList(renditions));
            return this;
        }

        @Override
        public final Builder renditions(Collection<RenditionConfigurationRendition> renditions) {
            this.renditions = RenditionConfigurationRenditionListCopier.copyEnumToString(renditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder renditions(RenditionConfigurationRendition ... renditions) {
            this.renditions(Arrays.asList(renditions));
            return this;
        }

        public RenditionConfiguration build() {
            return new RenditionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RenditionConfiguration> {
        public Builder renditionSelection(String var1);

        public Builder renditionSelection(RenditionConfigurationRenditionSelection var1);

        public Builder renditionsWithStrings(Collection<String> var1);

        public Builder renditionsWithStrings(String ... var1);

        public Builder renditions(Collection<RenditionConfigurationRendition> var1);

        public Builder renditions(RenditionConfigurationRendition ... var1);
    }
}

