/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivsrealtime.model.ReplicationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParticipantReplica
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParticipantReplica> {
    private static final SdkField<String> SOURCE_STAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceStageArn").getter(ParticipantReplica.getter(ParticipantReplica::sourceStageArn)).setter(ParticipantReplica.setter(Builder::sourceStageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceStageArn").build()}).build();
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("participantId").getter(ParticipantReplica.getter(ParticipantReplica::participantId)).setter(ParticipantReplica.setter(Builder::participantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()}).build();
    private static final SdkField<String> SOURCE_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceSessionId").getter(ParticipantReplica.getter(ParticipantReplica::sourceSessionId)).setter(ParticipantReplica.setter(Builder::sourceSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSessionId").build()}).build();
    private static final SdkField<String> DESTINATION_STAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationStageArn").getter(ParticipantReplica.getter(ParticipantReplica::destinationStageArn)).setter(ParticipantReplica.setter(Builder::destinationStageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationStageArn").build()}).build();
    private static final SdkField<String> DESTINATION_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationSessionId").getter(ParticipantReplica.getter(ParticipantReplica::destinationSessionId)).setter(ParticipantReplica.setter(Builder::destinationSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSessionId").build()}).build();
    private static final SdkField<String> REPLICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationState").getter(ParticipantReplica.getter(ParticipantReplica::replicationStateAsString)).setter(ParticipantReplica.setter(Builder::replicationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_STAGE_ARN_FIELD, PARTICIPANT_ID_FIELD, SOURCE_SESSION_ID_FIELD, DESTINATION_STAGE_ARN_FIELD, DESTINATION_SESSION_ID_FIELD, REPLICATION_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ParticipantReplica.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceStageArn;
    private final String participantId;
    private final String sourceSessionId;
    private final String destinationStageArn;
    private final String destinationSessionId;
    private final String replicationState;

    private ParticipantReplica(BuilderImpl builder) {
        this.sourceStageArn = builder.sourceStageArn;
        this.participantId = builder.participantId;
        this.sourceSessionId = builder.sourceSessionId;
        this.destinationStageArn = builder.destinationStageArn;
        this.destinationSessionId = builder.destinationSessionId;
        this.replicationState = builder.replicationState;
    }

    public final String sourceStageArn() {
        return this.sourceStageArn;
    }

    public final String participantId() {
        return this.participantId;
    }

    public final String sourceSessionId() {
        return this.sourceSessionId;
    }

    public final String destinationStageArn() {
        return this.destinationStageArn;
    }

    public final String destinationSessionId() {
        return this.destinationSessionId;
    }

    public final ReplicationState replicationState() {
        return ReplicationState.fromValue(this.replicationState);
    }

    public final String replicationStateAsString() {
        return this.replicationState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceStageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationStageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantReplica)) {
            return false;
        }
        ParticipantReplica other = (ParticipantReplica)obj;
        return Objects.equals(this.sourceStageArn(), other.sourceStageArn()) && Objects.equals(this.participantId(), other.participantId()) && Objects.equals(this.sourceSessionId(), other.sourceSessionId()) && Objects.equals(this.destinationStageArn(), other.destinationStageArn()) && Objects.equals(this.destinationSessionId(), other.destinationSessionId()) && Objects.equals(this.replicationStateAsString(), other.replicationStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ParticipantReplica").add("SourceStageArn", (Object)this.sourceStageArn()).add("ParticipantId", (Object)this.participantId()).add("SourceSessionId", (Object)this.sourceSessionId()).add("DestinationStageArn", (Object)this.destinationStageArn()).add("DestinationSessionId", (Object)this.destinationSessionId()).add("ReplicationState", (Object)this.replicationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceStageArn": {
                return Optional.ofNullable(clazz.cast(this.sourceStageArn()));
            }
            case "participantId": {
                return Optional.ofNullable(clazz.cast(this.participantId()));
            }
            case "sourceSessionId": {
                return Optional.ofNullable(clazz.cast(this.sourceSessionId()));
            }
            case "destinationStageArn": {
                return Optional.ofNullable(clazz.cast(this.destinationStageArn()));
            }
            case "destinationSessionId": {
                return Optional.ofNullable(clazz.cast(this.destinationSessionId()));
            }
            case "replicationState": {
                return Optional.ofNullable(clazz.cast(this.replicationStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("sourceStageArn", SOURCE_STAGE_ARN_FIELD);
        map.put("participantId", PARTICIPANT_ID_FIELD);
        map.put("sourceSessionId", SOURCE_SESSION_ID_FIELD);
        map.put("destinationStageArn", DESTINATION_STAGE_ARN_FIELD);
        map.put("destinationSessionId", DESTINATION_SESSION_ID_FIELD);
        map.put("replicationState", REPLICATION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipantReplica, T> g) {
        return obj -> g.apply((ParticipantReplica)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceStageArn;
        private String participantId;
        private String sourceSessionId;
        private String destinationStageArn;
        private String destinationSessionId;
        private String replicationState;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantReplica model) {
            this.sourceStageArn(model.sourceStageArn);
            this.participantId(model.participantId);
            this.sourceSessionId(model.sourceSessionId);
            this.destinationStageArn(model.destinationStageArn);
            this.destinationSessionId(model.destinationSessionId);
            this.replicationState(model.replicationState);
        }

        public final String getSourceStageArn() {
            return this.sourceStageArn;
        }

        public final void setSourceStageArn(String sourceStageArn) {
            this.sourceStageArn = sourceStageArn;
        }

        @Override
        public final Builder sourceStageArn(String sourceStageArn) {
            this.sourceStageArn = sourceStageArn;
            return this;
        }

        public final String getParticipantId() {
            return this.participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getSourceSessionId() {
            return this.sourceSessionId;
        }

        public final void setSourceSessionId(String sourceSessionId) {
            this.sourceSessionId = sourceSessionId;
        }

        @Override
        public final Builder sourceSessionId(String sourceSessionId) {
            this.sourceSessionId = sourceSessionId;
            return this;
        }

        public final String getDestinationStageArn() {
            return this.destinationStageArn;
        }

        public final void setDestinationStageArn(String destinationStageArn) {
            this.destinationStageArn = destinationStageArn;
        }

        @Override
        public final Builder destinationStageArn(String destinationStageArn) {
            this.destinationStageArn = destinationStageArn;
            return this;
        }

        public final String getDestinationSessionId() {
            return this.destinationSessionId;
        }

        public final void setDestinationSessionId(String destinationSessionId) {
            this.destinationSessionId = destinationSessionId;
        }

        @Override
        public final Builder destinationSessionId(String destinationSessionId) {
            this.destinationSessionId = destinationSessionId;
            return this;
        }

        public final String getReplicationState() {
            return this.replicationState;
        }

        public final void setReplicationState(String replicationState) {
            this.replicationState = replicationState;
        }

        @Override
        public final Builder replicationState(String replicationState) {
            this.replicationState = replicationState;
            return this;
        }

        @Override
        public final Builder replicationState(ReplicationState replicationState) {
            this.replicationState(replicationState == null ? null : replicationState.toString());
            return this;
        }

        public ParticipantReplica build() {
            return new ParticipantReplica(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParticipantReplica> {
        public Builder sourceStageArn(String var1);

        public Builder participantId(String var1);

        public Builder sourceSessionId(String var1);

        public Builder destinationStageArn(String var1);

        public Builder destinationSessionId(String var1);

        public Builder replicationState(String var1);

        public Builder replicationState(ReplicationState var1);
    }
}

