/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivsrealtime.model.CompositionThumbnailConfiguration;
import software.amazon.awssdk.services.ivsrealtime.model.CompositionThumbnailConfigurationListCopier;
import software.amazon.awssdk.services.ivsrealtime.model.EncoderConfigurationArnListCopier;
import software.amazon.awssdk.services.ivsrealtime.model.RecordingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DestinationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DestinationConfiguration> {
    private static final SdkField<String> STORAGE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageConfigurationArn").getter(S3DestinationConfiguration.getter(S3DestinationConfiguration::storageConfigurationArn)).setter(S3DestinationConfiguration.setter(Builder::storageConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfigurationArn").build()}).build();
    private static final SdkField<List<String>> ENCODER_CONFIGURATION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("encoderConfigurationArns").getter(S3DestinationConfiguration.getter(S3DestinationConfiguration::encoderConfigurationArns)).setter(S3DestinationConfiguration.setter(Builder::encoderConfigurationArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoderConfigurationArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RecordingConfiguration> RECORDING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recordingConfiguration").getter(S3DestinationConfiguration.getter(S3DestinationConfiguration::recordingConfiguration)).setter(S3DestinationConfiguration.setter(Builder::recordingConfiguration)).constructor(RecordingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingConfiguration").build()}).build();
    private static final SdkField<List<CompositionThumbnailConfiguration>> THUMBNAIL_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("thumbnailConfigurations").getter(S3DestinationConfiguration.getter(S3DestinationConfiguration::thumbnailConfigurations)).setter(S3DestinationConfiguration.setter(Builder::thumbnailConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CompositionThumbnailConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_CONFIGURATION_ARN_FIELD, ENCODER_CONFIGURATION_ARNS_FIELD, RECORDING_CONFIGURATION_FIELD, THUMBNAIL_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3DestinationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String storageConfigurationArn;
    private final List<String> encoderConfigurationArns;
    private final RecordingConfiguration recordingConfiguration;
    private final List<CompositionThumbnailConfiguration> thumbnailConfigurations;

    private S3DestinationConfiguration(BuilderImpl builder) {
        this.storageConfigurationArn = builder.storageConfigurationArn;
        this.encoderConfigurationArns = builder.encoderConfigurationArns;
        this.recordingConfiguration = builder.recordingConfiguration;
        this.thumbnailConfigurations = builder.thumbnailConfigurations;
    }

    public final String storageConfigurationArn() {
        return this.storageConfigurationArn;
    }

    public final boolean hasEncoderConfigurationArns() {
        return this.encoderConfigurationArns != null && !(this.encoderConfigurationArns instanceof SdkAutoConstructList);
    }

    public final List<String> encoderConfigurationArns() {
        return this.encoderConfigurationArns;
    }

    public final RecordingConfiguration recordingConfiguration() {
        return this.recordingConfiguration;
    }

    public final boolean hasThumbnailConfigurations() {
        return this.thumbnailConfigurations != null && !(this.thumbnailConfigurations instanceof SdkAutoConstructList);
    }

    public final List<CompositionThumbnailConfiguration> thumbnailConfigurations() {
        return this.thumbnailConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEncoderConfigurationArns() ? this.encoderConfigurationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThumbnailConfigurations() ? this.thumbnailConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DestinationConfiguration)) {
            return false;
        }
        S3DestinationConfiguration other = (S3DestinationConfiguration)obj;
        return Objects.equals(this.storageConfigurationArn(), other.storageConfigurationArn()) && this.hasEncoderConfigurationArns() == other.hasEncoderConfigurationArns() && Objects.equals(this.encoderConfigurationArns(), other.encoderConfigurationArns()) && Objects.equals(this.recordingConfiguration(), other.recordingConfiguration()) && this.hasThumbnailConfigurations() == other.hasThumbnailConfigurations() && Objects.equals(this.thumbnailConfigurations(), other.thumbnailConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"S3DestinationConfiguration").add("StorageConfigurationArn", (Object)this.storageConfigurationArn()).add("EncoderConfigurationArns", this.hasEncoderConfigurationArns() ? this.encoderConfigurationArns() : null).add("RecordingConfiguration", (Object)this.recordingConfiguration()).add("ThumbnailConfigurations", this.hasThumbnailConfigurations() ? this.thumbnailConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "storageConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.storageConfigurationArn()));
            }
            case "encoderConfigurationArns": {
                return Optional.ofNullable(clazz.cast(this.encoderConfigurationArns()));
            }
            case "recordingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.recordingConfiguration()));
            }
            case "thumbnailConfigurations": {
                return Optional.ofNullable(clazz.cast(this.thumbnailConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storageConfigurationArn", STORAGE_CONFIGURATION_ARN_FIELD);
        map.put("encoderConfigurationArns", ENCODER_CONFIGURATION_ARNS_FIELD);
        map.put("recordingConfiguration", RECORDING_CONFIGURATION_FIELD);
        map.put("thumbnailConfigurations", THUMBNAIL_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3DestinationConfiguration, T> g) {
        return obj -> g.apply((S3DestinationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String storageConfigurationArn;
        private List<String> encoderConfigurationArns = DefaultSdkAutoConstructList.getInstance();
        private RecordingConfiguration recordingConfiguration;
        private List<CompositionThumbnailConfiguration> thumbnailConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3DestinationConfiguration model) {
            this.storageConfigurationArn(model.storageConfigurationArn);
            this.encoderConfigurationArns(model.encoderConfigurationArns);
            this.recordingConfiguration(model.recordingConfiguration);
            this.thumbnailConfigurations(model.thumbnailConfigurations);
        }

        public final String getStorageConfigurationArn() {
            return this.storageConfigurationArn;
        }

        public final void setStorageConfigurationArn(String storageConfigurationArn) {
            this.storageConfigurationArn = storageConfigurationArn;
        }

        @Override
        public final Builder storageConfigurationArn(String storageConfigurationArn) {
            this.storageConfigurationArn = storageConfigurationArn;
            return this;
        }

        public final Collection<String> getEncoderConfigurationArns() {
            if (this.encoderConfigurationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.encoderConfigurationArns;
        }

        public final void setEncoderConfigurationArns(Collection<String> encoderConfigurationArns) {
            this.encoderConfigurationArns = EncoderConfigurationArnListCopier.copy(encoderConfigurationArns);
        }

        @Override
        public final Builder encoderConfigurationArns(Collection<String> encoderConfigurationArns) {
            this.encoderConfigurationArns = EncoderConfigurationArnListCopier.copy(encoderConfigurationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encoderConfigurationArns(String ... encoderConfigurationArns) {
            this.encoderConfigurationArns(Arrays.asList(encoderConfigurationArns));
            return this;
        }

        public final RecordingConfiguration.Builder getRecordingConfiguration() {
            return this.recordingConfiguration != null ? this.recordingConfiguration.toBuilder() : null;
        }

        public final void setRecordingConfiguration(RecordingConfiguration.BuilderImpl recordingConfiguration) {
            this.recordingConfiguration = recordingConfiguration != null ? recordingConfiguration.build() : null;
        }

        @Override
        public final Builder recordingConfiguration(RecordingConfiguration recordingConfiguration) {
            this.recordingConfiguration = recordingConfiguration;
            return this;
        }

        public final List<CompositionThumbnailConfiguration.Builder> getThumbnailConfigurations() {
            List<CompositionThumbnailConfiguration.Builder> result = CompositionThumbnailConfigurationListCopier.copyToBuilder(this.thumbnailConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThumbnailConfigurations(Collection<CompositionThumbnailConfiguration.BuilderImpl> thumbnailConfigurations) {
            this.thumbnailConfigurations = CompositionThumbnailConfigurationListCopier.copyFromBuilder(thumbnailConfigurations);
        }

        @Override
        public final Builder thumbnailConfigurations(Collection<CompositionThumbnailConfiguration> thumbnailConfigurations) {
            this.thumbnailConfigurations = CompositionThumbnailConfigurationListCopier.copy(thumbnailConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbnailConfigurations(CompositionThumbnailConfiguration ... thumbnailConfigurations) {
            this.thumbnailConfigurations(Arrays.asList(thumbnailConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbnailConfigurations(Consumer<CompositionThumbnailConfiguration.Builder> ... thumbnailConfigurations) {
            this.thumbnailConfigurations(Stream.of(thumbnailConfigurations).map(c -> (CompositionThumbnailConfiguration)((CompositionThumbnailConfiguration.Builder)CompositionThumbnailConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public S3DestinationConfiguration build() {
            return new S3DestinationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DestinationConfiguration> {
        public Builder storageConfigurationArn(String var1);

        public Builder encoderConfigurationArns(Collection<String> var1);

        public Builder encoderConfigurationArns(String ... var1);

        public Builder recordingConfiguration(RecordingConfiguration var1);

        default public Builder recordingConfiguration(Consumer<RecordingConfiguration.Builder> recordingConfiguration) {
            return this.recordingConfiguration((RecordingConfiguration)((RecordingConfiguration.Builder)RecordingConfiguration.builder().applyMutation(recordingConfiguration)).build());
        }

        public Builder thumbnailConfigurations(Collection<CompositionThumbnailConfiguration> var1);

        public Builder thumbnailConfigurations(CompositionThumbnailConfiguration ... var1);

        public Builder thumbnailConfigurations(Consumer<CompositionThumbnailConfiguration.Builder> ... var1);
    }
}

