/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventName {
    JOINED("JOINED"),
    LEFT("LEFT"),
    PUBLISH_STARTED("PUBLISH_STARTED"),
    PUBLISH_STOPPED("PUBLISH_STOPPED"),
    SUBSCRIBE_STARTED("SUBSCRIBE_STARTED"),
    SUBSCRIBE_STOPPED("SUBSCRIBE_STOPPED"),
    PUBLISH_ERROR("PUBLISH_ERROR"),
    SUBSCRIBE_ERROR("SUBSCRIBE_ERROR"),
    JOIN_ERROR("JOIN_ERROR"),
    REPLICATION_STARTED("REPLICATION_STARTED"),
    REPLICATION_STOPPED("REPLICATION_STOPPED"),
    TOKEN_EXCHANGED("TOKEN_EXCHANGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventName> VALUE_MAP;
    private final String value;

    private EventName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventName> knownValues() {
        EnumSet<EventName> knownValues = EnumSet.allOf(EventName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventName.class, EventName::toString);
    }
}

