/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Includes all client authentication information.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientAuthentication implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientAuthentication.Builder, ClientAuthentication> {
    private static final SdkField<Sasl> SASL_FIELD = SdkField.<Sasl> builder(MarshallingType.SDK_POJO).memberName("Sasl")
            .getter(getter(ClientAuthentication::sasl)).setter(setter(Builder::sasl)).constructor(Sasl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sasl").build()).build();

    private static final SdkField<Tls> TLS_FIELD = SdkField.<Tls> builder(MarshallingType.SDK_POJO).memberName("Tls")
            .getter(getter(ClientAuthentication::tls)).setter(setter(Builder::tls)).constructor(Tls::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tls").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SASL_FIELD, TLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Sasl sasl;

    private final Tls tls;

    private ClientAuthentication(BuilderImpl builder) {
        this.sasl = builder.sasl;
        this.tls = builder.tls;
    }

    /**
     *
     * <p>
     * Details for ClientAuthentication using SASL.
     * </p>
     * 
     * @return <p>
     *         Details for ClientAuthentication using SASL.
     *         </p>
     */
    public final Sasl sasl() {
        return sasl;
    }

    /**
     *
     * <p>
     * Details for ClientAuthentication using TLS.
     * </p>
     * 
     * @return <p>
     *         Details for ClientAuthentication using TLS.
     *         </p>
     */
    public final Tls tls() {
        return tls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sasl());
        hashCode = 31 * hashCode + Objects.hashCode(tls());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientAuthentication)) {
            return false;
        }
        ClientAuthentication other = (ClientAuthentication) obj;
        return Objects.equals(sasl(), other.sasl()) && Objects.equals(tls(), other.tls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientAuthentication").add("Sasl", sasl()).add("Tls", tls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sasl":
            return Optional.ofNullable(clazz.cast(sasl()));
        case "Tls":
            return Optional.ofNullable(clazz.cast(tls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientAuthentication, T> g) {
        return obj -> g.apply((ClientAuthentication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientAuthentication> {
        /**
         *
         * <p>
         * Details for ClientAuthentication using SASL.
         * </p>
         * 
         * @param sasl
         *        <p>
         *        Details for ClientAuthentication using SASL.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sasl(Sasl sasl);

        /**
         *
         * <p>
         * Details for ClientAuthentication using SASL.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link Sasl.Builder} avoiding the need to create one
         * manually via {@link Sasl#builder()}.
         *
         * When the {@link Consumer} completes, {@link Sasl.Builder#build()} is called immediately and its result is
         * passed to {@link #sasl(Sasl)}.
         * 
         * @param sasl
         *        a consumer that will call methods on {@link Sasl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sasl(Sasl)
         */
        default Builder sasl(Consumer<Sasl.Builder> sasl) {
            return sasl(Sasl.builder().applyMutation(sasl).build());
        }

        /**
         *
         * <p>
         * Details for ClientAuthentication using TLS.
         * </p>
         * 
         * @param tls
         *        <p>
         *        Details for ClientAuthentication using TLS.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tls(Tls tls);

        /**
         *
         * <p>
         * Details for ClientAuthentication using TLS.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link Tls.Builder} avoiding the need to create one
         * manually via {@link Tls#builder()}.
         *
         * When the {@link Consumer} completes, {@link Tls.Builder#build()} is called immediately and its result is
         * passed to {@link #tls(Tls)}.
         * 
         * @param tls
         *        a consumer that will call methods on {@link Tls.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tls(Tls)
         */
        default Builder tls(Consumer<Tls.Builder> tls) {
            return tls(Tls.builder().applyMutation(tls).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Sasl sasl;

        private Tls tls;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientAuthentication model) {
            sasl(model.sasl);
            tls(model.tls);
        }

        public final Sasl.Builder getSasl() {
            return sasl != null ? sasl.toBuilder() : null;
        }

        @Override
        public final Builder sasl(Sasl sasl) {
            this.sasl = sasl;
            return this;
        }

        public final void setSasl(Sasl.BuilderImpl sasl) {
            this.sasl = sasl != null ? sasl.build() : null;
        }

        public final Tls.Builder getTls() {
            return tls != null ? tls.toBuilder() : null;
        }

        @Override
        public final Builder tls(Tls tls) {
            this.tls = tls;
            return this;
        }

        public final void setTls(Tls.BuilderImpl tls) {
            this.tls = tls != null ? tls.build() : null;
        }

        @Override
        public ClientAuthentication build() {
            return new ClientAuthentication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
