/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Represents an MSK Configuration.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class Configuration implements SdkPojo, Serializable, ToCopyableBuilder<Configuration.Builder, Configuration> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Configuration::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(Configuration::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Configuration::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> KAFKA_VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("KafkaVersions")
            .getter(getter(Configuration::kafkaVersions))
            .setter(setter(Builder::kafkaVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ConfigurationRevision> LATEST_REVISION_FIELD = SdkField
            .<ConfigurationRevision> builder(MarshallingType.SDK_POJO).memberName("LatestRevision")
            .getter(getter(Configuration::latestRevision)).setter(setter(Builder::latestRevision))
            .constructor(ConfigurationRevision::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRevision").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Configuration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Configuration::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIME_FIELD, DESCRIPTION_FIELD, KAFKA_VERSIONS_FIELD, LATEST_REVISION_FIELD, NAME_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant creationTime;

    private final String description;

    private final List<String> kafkaVersions;

    private final ConfigurationRevision latestRevision;

    private final String name;

    private final String state;

    private Configuration(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.kafkaVersions = builder.kafkaVersions;
        this.latestRevision = builder.latestRevision;
        this.name = builder.name;
        this.state = builder.state;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the configuration.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the configuration.
     *         </p>
     */
    public final String arn() {
        return arn;
    }

    /**
     *
     * <p>
     * The time when the configuration was created.
     * </p>
     * 
     * @return <p>
     *         The time when the configuration was created.
     *         </p>
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     *
     * <p>
     * The description of the configuration.
     * </p>
     * 
     * @return <p>
     *         The description of the configuration.
     *         </p>
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the KafkaVersions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasKafkaVersions() {
        return kafkaVersions != null && !(kafkaVersions instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * An array of the versions of Apache Kafka with which you can use this MSK configuration. You can use this
     * configuration for an MSK cluster only if the Apache Kafka version specified for the cluster appears in this
     * array.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKafkaVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <p>
     *         An array of the versions of Apache Kafka with which you can use this MSK configuration. You can use this
     *         configuration for an MSK cluster only if the Apache Kafka version specified for the cluster appears in
     *         this array.
     *         </p>
     */
    public final List<String> kafkaVersions() {
        return kafkaVersions;
    }

    /**
     *
     * <p>
     * Latest revision of the configuration.
     * </p>
     * 
     * @return <p>
     *         Latest revision of the configuration.
     *         </p>
     */
    public final ConfigurationRevision latestRevision() {
        return latestRevision;
    }

    /**
     *
     * <p>
     * The name of the configuration.
     * </p>
     * 
     * @return <p>
     *         The name of the configuration.
     *         </p>
     */
    public final String name() {
        return name;
    }

    /**
     *
     * <p>
     * The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
     *         </p>
     * @see ConfigurationState
     */
    public final ConfigurationState state() {
        return ConfigurationState.fromValue(state);
    }

    /**
     *
     * <p>
     * The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
     *         </p>
     * @see ConfigurationState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasKafkaVersions() ? kafkaVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(latestRevision());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(description(), other.description()) && hasKafkaVersions() == other.hasKafkaVersions()
                && Objects.equals(kafkaVersions(), other.kafkaVersions())
                && Objects.equals(latestRevision(), other.latestRevision()) && Objects.equals(name(), other.name())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Configuration").add("Arn", arn()).add("CreationTime", creationTime())
                .add("Description", description()).add("KafkaVersions", hasKafkaVersions() ? kafkaVersions() : null)
                .add("LatestRevision", latestRevision()).add("Name", name()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "KafkaVersions":
            return Optional.ofNullable(clazz.cast(kafkaVersions()));
        case "LatestRevision":
            return Optional.ofNullable(clazz.cast(latestRevision()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Configuration, T> g) {
        return obj -> g.apply((Configuration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Configuration> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the configuration.
         * </p>
         * 
         * @param arn
         *        <p>
         *        The Amazon Resource Name (ARN) of the configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         *
         * <p>
         * The time when the configuration was created.
         * </p>
         * 
         * @param creationTime
         *        <p>
         *        The time when the configuration was created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         *
         * <p>
         * The description of the configuration.
         * </p>
         * 
         * @param description
         *        <p>
         *        The description of the configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         *
         * <p>
         * An array of the versions of Apache Kafka with which you can use this MSK configuration. You can use this
         * configuration for an MSK cluster only if the Apache Kafka version specified for the cluster appears in this
         * array.
         * </p>
         * 
         * @param kafkaVersions
         *        <p>
         *        An array of the versions of Apache Kafka with which you can use this MSK configuration. You can use
         *        this configuration for an MSK cluster only if the Apache Kafka version specified for the cluster
         *        appears in this array.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaVersions(Collection<String> kafkaVersions);

        /**
         *
         * <p>
         * An array of the versions of Apache Kafka with which you can use this MSK configuration. You can use this
         * configuration for an MSK cluster only if the Apache Kafka version specified for the cluster appears in this
         * array.
         * </p>
         * 
         * @param kafkaVersions
         *        <p>
         *        An array of the versions of Apache Kafka with which you can use this MSK configuration. You can use
         *        this configuration for an MSK cluster only if the Apache Kafka version specified for the cluster
         *        appears in this array.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaVersions(String... kafkaVersions);

        /**
         *
         * <p>
         * Latest revision of the configuration.
         * </p>
         * 
         * @param latestRevision
         *        <p>
         *        Latest revision of the configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRevision(ConfigurationRevision latestRevision);

        /**
         *
         * <p>
         * Latest revision of the configuration.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link ConfigurationRevision.Builder} avoiding the need
         * to create one manually via {@link ConfigurationRevision#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationRevision.Builder#build()} is called immediately and
         * its result is passed to {@link #latestRevision(ConfigurationRevision)}.
         * 
         * @param latestRevision
         *        a consumer that will call methods on {@link ConfigurationRevision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestRevision(ConfigurationRevision)
         */
        default Builder latestRevision(Consumer<ConfigurationRevision.Builder> latestRevision) {
            return latestRevision(ConfigurationRevision.builder().applyMutation(latestRevision).build());
        }

        /**
         *
         * <p>
         * The name of the configuration.
         * </p>
         * 
         * @param name
         *        <p>
         *        The name of the configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         *
         * <p>
         * The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
         * </p>
         * 
         * @param state
         *        <p>
         *        The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
         *        </p>
         * @see ConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationState
         */
        Builder state(String state);

        /**
         *
         * <p>
         * The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
         * </p>
         * 
         * @param state
         *        <p>
         *        The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
         *        </p>
         * @see ConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationState
         */
        Builder state(ConfigurationState state);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant creationTime;

        private String description;

        private List<String> kafkaVersions = DefaultSdkAutoConstructList.getInstance();

        private ConfigurationRevision latestRevision;

        private String name;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(Configuration model) {
            arn(model.arn);
            creationTime(model.creationTime);
            description(model.description);
            kafkaVersions(model.kafkaVersions);
            latestRevision(model.latestRevision);
            name(model.name);
            state(model.state);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getKafkaVersions() {
            if (kafkaVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return kafkaVersions;
        }

        @Override
        public final Builder kafkaVersions(Collection<String> kafkaVersions) {
            this.kafkaVersions = ___listOf__stringCopier.copy(kafkaVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kafkaVersions(String... kafkaVersions) {
            kafkaVersions(Arrays.asList(kafkaVersions));
            return this;
        }

        public final void setKafkaVersions(Collection<String> kafkaVersions) {
            this.kafkaVersions = ___listOf__stringCopier.copy(kafkaVersions);
        }

        public final ConfigurationRevision.Builder getLatestRevision() {
            return latestRevision != null ? latestRevision.toBuilder() : null;
        }

        @Override
        public final Builder latestRevision(ConfigurationRevision latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        public final void setLatestRevision(ConfigurationRevision.BuilderImpl latestRevision) {
            this.latestRevision = latestRevision != null ? latestRevision.build() : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ConfigurationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public Configuration build() {
            return new Configuration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
