/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNodesResponse extends KafkaResponse implements
        ToCopyableBuilder<ListNodesResponse.Builder, ListNodesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListNodesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<NodeInfo>> NODE_INFO_LIST_FIELD = SdkField
            .<List<NodeInfo>> builder(MarshallingType.LIST)
            .memberName("NodeInfoList")
            .getter(getter(ListNodesResponse::nodeInfoList))
            .setter(setter(Builder::nodeInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NodeInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            NODE_INFO_LIST_FIELD));

    private final String nextToken;

    private final List<NodeInfo> nodeInfoList;

    private ListNodesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.nodeInfoList = builder.nodeInfoList;
    }

    /**
     *
     * <p>
     * The paginated results marker. When the result of a ListNodes operation is truncated, the call returns NextToken
     * in the response. To get another batch of nodes, provide this token in your next request.
     * </p>
     * 
     * @return <p>
     *         The paginated results marker. When the result of a ListNodes operation is truncated, the call returns
     *         NextToken in the response. To get another batch of nodes, provide this token in your next request.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the NodeInfoList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasNodeInfoList() {
        return nodeInfoList != null && !(nodeInfoList instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * List containing a NodeInfo object.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNodeInfoList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <p>
     *         List containing a NodeInfo object.
     *         </p>
     */
    public final List<NodeInfo> nodeInfoList() {
        return nodeInfoList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeInfoList() ? nodeInfoList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNodesResponse)) {
            return false;
        }
        ListNodesResponse other = (ListNodesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasNodeInfoList() == other.hasNodeInfoList()
                && Objects.equals(nodeInfoList(), other.nodeInfoList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNodesResponse").add("NextToken", nextToken())
                .add("NodeInfoList", hasNodeInfoList() ? nodeInfoList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "NodeInfoList":
            return Optional.ofNullable(clazz.cast(nodeInfoList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNodesResponse, T> g) {
        return obj -> g.apply((ListNodesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListNodesResponse> {
        /**
         *
         * <p>
         * The paginated results marker. When the result of a ListNodes operation is truncated, the call returns
         * NextToken in the response. To get another batch of nodes, provide this token in your next request.
         * </p>
         * 
         * @param nextToken
         *        <p>
         *        The paginated results marker. When the result of a ListNodes operation is truncated, the call returns
         *        NextToken in the response. To get another batch of nodes, provide this token in your next request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         *
         * <p>
         * List containing a NodeInfo object.
         * </p>
         * 
         * @param nodeInfoList
         *        <p>
         *        List containing a NodeInfo object.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeInfoList(Collection<NodeInfo> nodeInfoList);

        /**
         *
         * <p>
         * List containing a NodeInfo object.
         * </p>
         * 
         * @param nodeInfoList
         *        <p>
         *        List containing a NodeInfo object.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeInfoList(NodeInfo... nodeInfoList);

        /**
         *
         * <p>
         * List containing a NodeInfo object.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link List<NodeInfo>.Builder} avoiding the need to
         * create one manually via {@link List<NodeInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NodeInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #nodeInfoList(List<NodeInfo>)}.
         * 
         * @param nodeInfoList
         *        a consumer that will call methods on {@link List<NodeInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeInfoList(List<NodeInfo>)
         */
        Builder nodeInfoList(Consumer<NodeInfo.Builder>... nodeInfoList);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<NodeInfo> nodeInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNodesResponse model) {
            super(model);
            nextToken(model.nextToken);
            nodeInfoList(model.nodeInfoList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<NodeInfo.Builder> getNodeInfoList() {
            List<NodeInfo.Builder> result = ___listOfNodeInfoCopier.copyToBuilder(this.nodeInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder nodeInfoList(Collection<NodeInfo> nodeInfoList) {
            this.nodeInfoList = ___listOfNodeInfoCopier.copy(nodeInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInfoList(NodeInfo... nodeInfoList) {
            nodeInfoList(Arrays.asList(nodeInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInfoList(Consumer<NodeInfo.Builder>... nodeInfoList) {
            nodeInfoList(Stream.of(nodeInfoList).map(c -> NodeInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNodeInfoList(Collection<NodeInfo.BuilderImpl> nodeInfoList) {
            this.nodeInfoList = ___listOfNodeInfoCopier.copyFromBuilder(nodeInfoList);
        }

        @Override
        public ListNodesResponse build() {
            return new ListNodesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
